/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

void
gsh_check_results(char **results)
{
    /* This ensures that the result string is not empty, avoiding certain formatting problems.  */
    /* Otherwise, a GTK warning is produced.  */
    if(!strncmp(*results, "", 1))
    {
        free(*results);
        asprintf(results, " ");
    }
}

void
gsh_update_label(char *command, void *widget)
{
	char *results;

#ifdef DEBUG
	puts("gsh_update_label()");
#endif

	results=antiright_pipe_read(command);

    gsh_check_results(&results);

	gsh_set_label((GtkWidget*)widget, results);
	free(results);
}

void
gsh_add_updated_label(struct GSH *gsh, char *command)
{
	GtkWidget *widget;

#ifdef DEBUG
	puts("gsh_add_updated_label()");
#endif
	widget=gtk_label_new("");
	gsh_manage(gsh, widget);
	gsh_add_updater(&gsh_update_label, command, (void*)widget);
}

