/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
     setup_label(GtkWidget *widget, char *command);

static void
setup_label(GtkWidget *widget, char *command)
{
	gchar *formatted;

	formatted = antiright_beautified_label(command);
	gtk_button_set_label(GTK_BUTTON(widget), formatted);
	free(formatted);
}
void
gsh_command_button(struct GSH * gsh, char *command)
{
#ifdef DEBUG
	ARBUG("gsh_command_button");
#endif				/* DEBUG */

	ARPASSERT(gsh);

	
	gsh->button = gtk_button_new();

	setup_label(gsh->button, command);

	gsh_setup_drag_drop(gsh, gsh->button);

	{
		struct GSH_CBData * cb;

		/* Allocate and initialize elements.  */
		cb = (struct GSH_CBData *) xmalloc(sizeof(struct GSH_CBData));

		cb->gsh = gsh;
		cb->data = command;	/* command from argv, literal, or
				 	 * preallocated.  */

		/* @null@ */
		(void) g_signal_connect(G_OBJECT(gsh->button), "clicked",
				G_CALLBACK(system_cb), cb);

	}

	gsh_manage_unexpanded(gsh, gsh->button);

#ifdef DEBUG
	g_debug("==> row: %d out of %d rows\n",
		gsh->rows.row, gsh->rows.rows);
#endif				/* DEBUG */
}


