/*
 AntiRight (c) 2007 Jeffrey Bedard antiright@gmail.com

 This file is part of AntiRight.

 AntiRight is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 AntiRight is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 AntiRight; if not, write to the Free Software Foundation, Inc., 51 Franklin
 Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

/*
 * Portions Copyright 2005 Ryan McDougall, GNU GPL terms. Based on drag
 * and drop tutorial: http://live.gnome.org/GnomeLove/DragNDropTutorial
 */

enum
{
	TARGET_STRING
};

static GtkTargetEntry target_list[] =
{
	{"text/plain", 0, TARGET_STRING}
};

static guint n_targets = G_N_ELEMENTS(target_list);

static void
drag_received(GtkWidget *widget, GdkDragContext * context, gint x,
	      gint y, GtkSelectionData * selection, guint target_type,
	      guint time, gpointer data);

static gboolean
drag_drop(GtkWidget *widget, GdkDragContext * context, gint x,
	  gint y, guint time, gpointer data);

static void
drag_data_get(GtkWidget *widget, GdkDragContext * context,
	      GtkSelectionData * selection, guint target_type,
	      guint time, gpointer data);

/*static void
     drag_begin(GtkWidget *widget, GdkDragContext * context, gpointer data);

static void
     drag_end(GtkWidget *widget, GdkDragContext * context, gpointer data);*/

void
gsh_setup_drag_drop(struct GSH * gsh, GtkWidget *widget)
{
	gtk_drag_dest_set(widget, GTK_DEST_DEFAULT_MOTION
		 | GTK_DEST_DEFAULT_HIGHLIGHT, target_list, n_targets,
			  GDK_ACTION_COPY);

	gtk_drag_source_set(widget, GDK_BUTTON1_MASK, target_list, n_targets,
			    GDK_ACTION_COPY);

	(void) g_signal_connect(widget, "drag-data-received",
				G_CALLBACK(drag_received), NULL);
	(void) g_signal_connect(widget, "drag-drop", 
				G_CALLBACK(drag_drop), NULL);
	(void) g_signal_connect(widget, "drag-data-get",
				G_CALLBACK(drag_data_get), NULL);

	if ((gsh->bflags & GSH_CBEXIT) == GSH_CBEXIT)
		(void) g_signal_connect(widget, "drag-end",
				        G_CALLBACK(gtk_main_quit), NULL);
}

static void
drag_received(GtkWidget *widget, GdkDragContext * context, gint x,
	      gint y, GtkSelectionData * selection, guint target_type,
	      guint time, gpointer data)
{
	gboolean drag_status;

	UNUSED(x);
	UNUSED(y);
	UNUSED(data);

	switch (target_type)
	{
	case TARGET_STRING:
	{
		const gchar *label;
		label=gtk_button_get_label(GTK_BUTTON(widget));
		sysprintf("%s %s", (const gchar *)label, 
			  (gchar *) selection->data);
		drag_status = TRUE;
		break;
	}
	default:
		drag_status = FALSE;
		ARWARN("invalid data dropped");
	}

	gtk_drag_finish(context, drag_status, FALSE, time);
}

static gboolean
drag_drop(GtkWidget *widget, GdkDragContext * context, gint x,
	  gint y, guint time, gpointer data)
{
	GdkAtom target_type;

	UNUSED(x);
	UNUSED(y);
	UNUSED(data);

	target_type =
		GDK_POINTER_TO_ATOM(g_list_nth_data(context->targets,
						    TARGET_STRING));

	ARIFP(context->targets)
	{
		gtk_drag_get_data(widget, context, target_type, time);
		return TRUE;
	}
	else
	return FALSE;
}

static void
drag_data_get(GtkWidget *widget, GdkDragContext * context,
	      GtkSelectionData * selection, guint target_type,
	      guint time, gpointer data)
{
	const gchar *source_data;

	UNUSED(context);
	UNUSED(target_type);
	UNUSED(time);
	UNUSED(data);

	source_data = gtk_button_get_label(GTK_BUTTON(widget));

	gtk_selection_data_set(selection, selection->target, sizeof(gchar),
			 (guchar *) source_data, strlen(source_data));
}

/* Use to set icon.  */
/*static void
drag_begin(GtkWidget *widget, GdkDragContext * context, gpointer data)
{
}

static void
drag_end(GtkWidget *widget, GdkDragContext * context, gpointer data)
{
}*/
