/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"


static void 
generic_image_button(struct GSH * gsh, char *command, 
		     GtkWidget * image)
{
	gsh_command_button(gsh, command);
	gtk_button_set_image(GTK_BUTTON(gsh->button), image);
	gtk_button_set_relief(GTK_BUTTON(gsh->button), GTK_RELIEF_NONE);
}

void
gsh_stock_image_button(struct GSH * gsh, char *command, char *stock_id)
{
	GtkWidget *image;

	image=gtk_image_new_from_stock((const gchar *)stock_id,
				       GTK_ICON_SIZE_DND);
	generic_image_button(gsh, command, image);
}

void
gsh_image_button(struct GSH * gsh, char *command, char *filename)
{
	GtkWidget *image;

	image = gtk_image_new_from_file(filename);
	generic_image_button(gsh, command, image);
}

static void
generic_add(struct GSH * gsh, int argc, char **argv, int *counter,
	    void (*button_func)(struct GSH *, char *, char *))
{
	gsh_count(argc, counter);
	(*button_func)(gsh, argv[(*counter)], argv[(*counter) + 1]);
	gsh_count(argc, counter);
}

void
gsh_handle_add_image_button(struct GSH * gsh, int argc, 
			    char **argv, int *counter)
{
	generic_add(gsh, argc, argv, counter, &gsh_image_button);
}

void
gsh_handle_add_stock_button(struct GSH * gsh, int argc, char **argv, 
			    int * counter)
{
	generic_add(gsh, argc, argv, counter, &gsh_stock_image_button);
}

void
gsh_handle_add_unlabeled_image_button(struct GSH * gsh, int argc, 
				      char **argv, int *counter)
{
	gsh_handle_add_image_button(gsh, argc, argv, counter);
	gtk_button_set_label(GTK_BUTTON(gsh->button), "");
}

