/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"


static void
set_options(struct GSH * gsh, GtkWidget *label)
{
	gtk_label_set_single_line_mode(GTK_LABEL(label), FALSE);

	if((gsh->bflags & GSH_HORIZONTAL_LABELS) == GSH_HORIZONTAL_LABELS)
		gtk_label_set_angle(GTK_LABEL(label), 90.0);
	else
		gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);

	gsh_widget_set_font_mono(label);
}

GtkWidget *
gsh_add_label(struct GSH * gsh, char *text)
{
	GtkWidget *label;
	GtkWidget *to_be_managed;

	ARPASSERT(gsh);

	label = gtk_label_new(text);

	ARPASSERT(label);

	set_options(gsh, label);

	if ((gsh->bflags & GSH_FRAMED_LABELS) == GSH_FRAMED_LABELS)
	{
		GtkWidget *frame;

		frame = gtk_frame_new(NULL);
		gtk_container_add(GTK_CONTAINER(frame), label);
		gtk_widget_show(label);
		to_be_managed = frame;
	}
	else
		to_be_managed = label;

	/*
	 * This uses expanded management, as the label may be
	 * displaying a large text area.
	 */
	gsh_manage(gsh, to_be_managed);

	return label;
}

void
gsh_set_label(GtkWidget *label, char *text)
{
	ARPASSERT(label);
	/* Text is not checked, as empty labels are allowed. */
	gtk_label_set_text(GTK_LABEL(label), text);
}
