/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

#define SPLIT_ALL -1

static void
new_button(struct GSH * gsh, gchar * string)
{
	gchar **pair;

	pair=g_strsplit(string, ",", 2);


	if(ARPBOOL(pair[0]) && ARPBOOL(pair[1]))
	{
		gchar * command;

		ar_asprintf(&command, "%s", pair[0]);
		gsh_image_button(gsh, command, pair[1]);
	}
	else
		gsh_command_button(gsh, string);

	g_strfreev(pair);
}

static void
menuitem_parse(struct GSH * gsh, gchar * string)
{
	/*@only@*/ gchar **pair;

	pair=g_strsplit(string, ",", 2);

	{
		/*@shared@*/ gchar * command;

		{
			gint read;

			read=ar_asprintf(&command, "%s", pair[0]);
			if(read == 0)
				ARWARN("NULL command");
		}

		if(ARPBOOL(pair[0]) && ARPBOOL(pair[1]))
			gsh_image_button(gsh, command, pair[1]);
		else
			gsh_command_button(gsh, command);
	}

	g_strfreev(pair);
}

static gint
popup_handler(GtkWidget * widget, GdkEvent * event)
{
	GdkEventButton *event_button;

	event_button=(GdkEventButton *)event;
	gtk_menu_popup(GTK_MENU(widget), NULL, NULL, NULL, NULL, 
		event_button->button, event_button->time);

	return TRUE;
}

static void
button_parse(struct GSH * gsh, const gchar * string)
{
	gchar **tokens;
	gint i;

	tokens=g_strsplit(string, "::", SPLIT_ALL);
	if(ARPBOOL(tokens[1]))
	{
		GtkWidget * oldrow;

		oldrow=gsh->rows.v;

		/* Set gsh->rows.v to a row within a menu.
		 * Create the menu before overwriting, then
		 * set back at end.  */
		gsh->bflags |= GSH_MENU_BUTTON;
		new_button(gsh, tokens[0]);
		gsh->rows.v=gtk_menu_new(); 
		gtk_widget_show(gsh->rows.v);
		g_signal_connect_swapped(gsh->button, "clicked",
			G_CALLBACK(popup_handler), gsh->rows.v);

		for(i=1; ARPBOOL(tokens[i]); i++)
			menuitem_parse(gsh, tokens[i]);

		gsh->rows.v=oldrow;
	}
	else
		new_button(gsh, (char *)string);

	g_strfreev(tokens);
}

void
gsh_parse_arguments(struct GSH * gsh, int argc, char **argv)
{
	int counter;

	for (counter = 1; counter < argc; counter++)
		if (argv[counter][0] == '-')
			gsh_handle_switch_arguments(gsh, argc, argv, &counter);
		else
			button_parse(gsh, argv[counter]);
}
