/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

gint
ar_asprintf(gchar **string, const gchar *format,...)
{
	va_list list;
	gint return_value;

	va_start(list, format);
	return_value = g_vasprintf(string, format, list);
	va_end(list);

	ARASSERT(return_value != -1);

	return return_value;
}

static gint
get_last_space(const gchar * text, gint length)
{
	gint i;

	for(i = 0; (i < length) && (*(text+length-i) != ' '); i++);

	return length - i;
}

static void
substitute(gchar **formatted, gint length)
{
	gint i;

	for (i = 0; i < length; i++)
	{
		if ((*formatted)[i] == '_')
			(*formatted)[i]=' ';
		/* This substitution is needed for constructing ACE
		 * commands on drag & drop.  */
		if ((*formatted)[i] == '@')
			(*formatted)[i]='_';
	}

	/* Ensure that the string is null-terminated.  */
	(*formatted)[i]='\0';
}

/* Free the returned value!  */
char *
antiright_beautified_label(char *text)
{
	gint length;
	gchar *formatted;

	length=strlen(text);
	text += get_last_space(text, length);
	length=ar_asprintf(&formatted, "%s", text);
	substitute(&formatted, length);

	return (formatted);
}

