/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gshterm.h"

char *
gshterm_construct_command(struct GSHTerm * term, int argc, char **argv)
{
	gchar *command;

	command = (gchar*)"";		/* Initialize to empty for the first
				 * concatenation.  */

	ARIFNB(gshterm_construct_command_from_args(
		term, argc, argv, &command))
	{
		char *shell;

		shell = getenv("SHELL");
		ARIFNP(shell)
			ar_asprintf(&command, "/bin/sh");
		else
		ar_asprintf(&command, "%s", shell);
	}

	return (command);
}

static gboolean
gshterm_handle_command_line_option(struct GSHTerm * term, 
				   gchar option, gchar *arg)
{
	ARIFNP(arg)
	{
		ARWARN("gshterm: invalid argument");
		return FALSE;
	}

#ifdef DEBUG
	putchar(option);
#endif				/* DEBUG */

	switch (option)
	{
	case 'e':
		return TRUE;
	case 'f':
		ar_asprintf(&term->font, arg);
		break;
	case 'g':
		ar_asprintf(&term->gsh->geometry, arg);
		break;
	case 's':
		term->font_size = (gint) atoi(arg);
		break;
	default:
		g_warning("gshterm: unknown option: -%c\n", option);
	}
	return FALSE;
}

gboolean
gshterm_construct_command_from_args(
	struct GSHTerm * term, int argc, char **argv, gchar **command)
{
	int counter;
	gboolean exec_reached;

#ifdef DEBUG
	puts(*command);
#endif				/* DEBUG */

	for (counter = 1, exec_reached = FALSE; counter < argc; counter++)
	{
		if (exec_reached)
			ar_asprintf(command, "%s %s ", *command, argv[counter]);
		else if (argv[counter][0] == '-')
			exec_reached = gshterm_handle_command_line_option(
			   term, argv[counter][1], argv[counter + 1]);

#ifdef DEBUG
		g_print("\n%d\t%s\n", counter, argv[counter]);
#endif				/* DEBUG */

	}

	return (exec_reached);
}
