/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_message_dialog(struct GSH * gsh, 
		   GtkMessageType type, 
		   char *text) __attribute__((noreturn));

static void
gsh_setup_message_dialog(struct GSH * gsh, 
			 int argc, char **argv,
			 unsigned int *counter, 
			 GtkMessageType type) __attribute__((noreturn));

static void
gsh_font_dialog() __attribute__((noreturn));

static void
gsh_color_dialog() __attribute__((noreturn));

static void
gsh_about_dialog() __attribute__((noreturn));


static void
gsh_message_dialog(struct GSH * gsh, GtkMessageType type, char *text)
{
	GtkWidget *dialog;

	dialog = gtk_message_dialog_new(
					GTK_WINDOW(gsh->window),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					type,
					GTK_BUTTONS_CLOSE,
					(gchar *) text);
	gtk_dialog_run(GTK_DIALOG(dialog));
	exit(0);
}

static void
gsh_setup_message_dialog(struct GSH * gsh, int argc, char **argv,
			 unsigned int *counter, GtkMessageType type)
{
	gsh_count(argc, counter);
	gsh_message_dialog(gsh, type, argv[(*counter)]);
}

static void
gsh_font_dialog()
{
	GtkWidget *dialog;

	dialog = gtk_font_selection_dialog_new("Font Selector");
	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK)
	{
		gchar *font;

		font = gtk_font_selection_dialog_get_font_name(
				   GTK_FONT_SELECTION_DIALOG(dialog));
		g_print("%s\n", font);
		g_free(font);
	}

	exit(0);
}

static void
gsh_color_dialog()
{
	const GtkWidget *dialog;

	dialog = gtk_color_selection_dialog_new("Color Selector");

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK)
	{
		GdkColor color;

		gtk_color_selection_get_current_color(
						  GTK_COLOR_SELECTION(
				    GTK_COLOR_SELECTION_DIALOG(dialog)
							  ->colorsel),
						      &color);

		g_print("#%x%x%x\n", color.red, color.green, color.blue);

	}

	exit(0);
}

static void
gsh_about_dialog()
{
	const GtkWidget *dialog;
	const gchar *authors[] =
	{"Jeffrey E. Bedard <antiright@gmail.com>",
	NULL};

	dialog = gtk_about_dialog_new();

	gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(dialog),
				     PACKAGE_STRING);

	gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(dialog),
			    "Copyright 2002-2007, Jeffrey E. Bedard");

	gtk_about_dialog_set_website(GTK_ABOUT_DIALOG(dialog),
				   "http://www.nongnu.org/antiright");

	gtk_about_dialog_set_license(GTK_ABOUT_DIALOG(dialog),
			   "This software is licensed under the terms"
			       " of the GNU General Public License.");

	gtk_about_dialog_set_authors(GTK_ABOUT_DIALOG(dialog),
				     authors);

	gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(dialog),
				"The desktop scripting environment.");

	gtk_dialog_run(GTK_DIALOG(dialog));

	exit(0);
}

void
gsh_handle_dialog_arguments(struct GSH * gsh, int argc, char **argv,
			    int *counter)
{
	g_assert(strlen(argv[(*counter)]) > 2);
	ARPASSERT(gsh);

	switch (argv[(*counter)][2])
	{
	case 'a':
		gsh_about_dialog();
		break;
	case 'c':		/* Color Selection */
		gsh_color_dialog();
		break;
	case 'D':		/* Folder Creation Selector */
		gsh_folder_create_dialog(gsh);
		break;
	case 'd':		/* Folder Selector */
		gsh_folder_open_dialog(gsh);
		break;
	case 'e':		/* Error Message */
		gsh_setup_message_dialog(gsh, argc, argv,
					 counter, GTK_MESSAGE_ERROR);
		break;
	case 'F':		/* Font Selection */
		gsh_font_dialog();
		break;
	case 'f':		/* File Selection */
		gsh_file_open_dialog(gsh);
		break;
	case 'i':		/* Information */
		gsh_setup_message_dialog(gsh, argc, argv,
					 counter, GTK_MESSAGE_INFO);
		break;
	case 's':		/* Filename Selection for Saving */
		gsh_file_save_dialog(gsh);
		break;
	case 'w':		/* Warning */
		gsh_setup_message_dialog(gsh, argc, argv,
					 counter,
					 GTK_MESSAGE_WARNING);
		break;

	}
}
