/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
add_new_window(struct GSH * gsh)
{
	gsh->window=gsh_create_main_window();
	gsh->rows.row=1;
	gsh_setup_containers(gsh);
	gtk_widget_show(gsh->window);
}

static void
add_piped_label(struct GSH * gsh, gchar * output)
{
	gsh_add_label(gsh, output);
}

static void
add_piped_text(struct GSH * gsh, gchar * output)
{
	GtkWidget * widget;

	widget=gsh_text_area(gsh);
	gsh_text_area_set_text(widget, output);
}

static void 
add_piped_generic(struct GSH * gsh, void (*add)(struct GSH *, gchar *))
{
	gchar *output;
	output=antiright_read_file(stdin);
	(*add)(gsh, output);
	g_free(output);
}

void
gsh_handle_add_arguments(struct GSH * gsh, int argc, char **argv, int *counter)
{
	g_assert(strlen(argv[(*counter)]) > 1);
	switch (argv[(*counter)][2])
	{
	case 'e':
		gsh_count(argc, counter);
		gsh_text_editor(gsh, argv[*counter]);
		break;

	case 'l':
		gsh_count(argc, counter);
		gsh_add_label(gsh, argv[(*counter)]);
		break;

	case 'P':
		add_piped_generic(gsh, &add_piped_text);
		break;

	case 'p':
		add_piped_generic(gsh, &add_piped_label);
		break;

	case 'r': /* Force creation of a new row.  */
		gsh_new_row(gsh);
		break;

	case 's': /* Add a shell.  */
		gsh_count(argc, counter);
		gsh_setup_terminal(gsh, argv[*counter]);
		break;

	case 't':
		if (argc != *counter)
			gsh_count(argc, counter);

		gsh_setup_command_entry(gsh, argv[(*counter)]);

		break;
	case 'T':
		gsh_text_area(gsh);
		break;

	case 'u':
		gsh_handle_updated_arguments(gsh, argc, argv, counter);
		break;

	case 'w':
		add_new_window(gsh);
		break;

	default:
		ARWARN("invalid add option");
	}
}
