/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
setup_quit_signal(GtkWidget * window, const gchar * signal)
{
	(void) g_signal_connect(window, signal, 
			G_CALLBACK(gtk_main_quit), NULL);
}

static void
setup_quit_signals(GtkWidget * window)
{
	setup_quit_signal(window, "delete-event");
	setup_quit_signal(window, "destroy");
}

GtkWidget *
gsh_create_main_window()
{
	GtkWidget *window;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	setup_quit_signals(window);

	return (window);
}
static void
gsh_GSH_Rows(struct GSH_Rows * rows)
{
	rows->row = 1;
	/* Use an arbitrary, though reasonable, initial number of rows.  */
	rows->rows = 8;
}
static void
gsh_GSH_Updater(struct GSH_Updater * update)
{
	update->period = 1000;

	/* Pointer must have not previously been used.  */
	update->list = (GSList *) NULL;
}
void
gsh_GSH(struct GSH * gsh)
{
	gsh->geometry = (gchar *)NULL;
	gsh->bflags=0;
	gsh_GSH_Rows(&gsh->rows);
	gsh_GSH_Updater(&gsh->update);
}
struct GSH *
gsh_new_GSH()
{
	struct GSH *gsh;

	gsh = (struct GSH *) xmalloc(sizeof(struct GSH));
	gsh_GSH(gsh);

	return gsh;
}
struct GSH *
gsh_init(int *argc, char ***argv)
{
	struct GSH *gsh;

	gsh = gsh_new_GSH();
	gsh_stack_init(gsh, argc, argv);

	return gsh;
}
void
gsh_stack_init(struct GSH * gsh, int *argc, char ***argv)
{
	gtk_init(argc, argv);
	gsh_GSH(gsh);
	gsh->window = gsh_create_main_window();
}


