/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

int
main(int argc, char **argv)
{
	//Store application structure on stack.
	struct GSH gsh;

	gsh.terminal.script=NULL;

	gsh_stack_init(&gsh, &argc, &argv);

#ifdef DEBUG
	g_debug("rows:\t%d\n", gsh.rows.rows);
	g_debug("row:\t%d\n", gsh.rows.row);
#endif				/* DEBUG */

	gsh.bflags |= (((argc > 1) && (strlen(argv[1]) == 3))
		 && !strncmp(argv[1], "-os", 3)) ? GSH_SCROLL : GSH_NONE;

	gsh_setup_containers(&gsh);
	gsh_parse_arguments(&gsh, argc, argv);
	gsh_setup_base_container(&gsh);

	gsh_check_and_set_geometry(&gsh);
	gtk_widget_show(gsh.window);
	gtk_main();

	if(gsh.terminal.script != NULL)
	{
		unlink(gsh.terminal.script);
		free(gsh.terminal.script);
	}

	return (EXIT_SUCCESS);
}
