/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_manage_generic(struct GSH * gsh, GtkWidget *widget)
{

#ifdef DEBUG
	ARBUG("gsh_manage()");
#endif				/* DEBUG */

	gtk_widget_show(widget);
	gsh->rows.row++;

#ifdef DEBUG
	g_debug("==> gsh_row: %d, gsh_rows: %d",
		gsh->rows.row, gsh->rows.rows);
#endif				/* DEBUG */

}
void
gsh_manage(struct GSH * gsh, GtkWidget *widget)
{
	if(GTK_IS_MENU(gsh->rows.v))
	{
		gtk_menu_shell_append(GTK_MENU_SHELL(gsh->rows.v), widget);
	}
	else
	{
		gsh_check_row(gsh);
		gtk_container_add(GTK_CONTAINER(gsh->rows.v), widget);
		gsh_manage_generic(gsh, widget);
	}
}

void
gsh_manage_unexpanded(struct GSH * gsh, GtkWidget *widget)
{

	/*
	 * Checking for a 1 row counter allows the ACE Deskbar to
	 * maintain a decent appearance.
	 */
	if ((gsh->rows.rows != 1) && !GTK_IS_MENU(gsh->rows.v))
	{
		gsh_check_row(gsh);
		gtk_box_pack_start(GTK_BOX(gsh->rows.v), widget,
				   FALSE, FALSE, 0);
		gsh_manage_generic(gsh, widget);
	}
	else
		gsh_manage(gsh, widget);
}

void
gsh_new_row(struct GSH * gsh)
{
	gsh->rows.v = gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(gsh->rows.h), gsh->rows.v);
	gtk_widget_show(gsh->rows.v);
	gsh->rows.row = 1;
}

void
gsh_check_row(struct GSH * gsh)
{

#ifdef DEBUG
	ARBUG("gsh_check_row()");
	g_debug("==> gsh_row: %d, gsh_rows: %d",
		gsh->rows.row, gsh->rows.rows);
#endif

	if (gsh->rows.row > gsh->rows.rows)
	{

#ifdef DEBUG
		ARBUG("new row");
#endif

		gsh_new_row(gsh);
	}
}
