/*
   AntiRight
   (c) 2007 Jeffrey Bedard
   antiright@gmail.com

   This file is part of AntiRight.

   AntiRight is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   AntiRight is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with AntiRight; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
   */

#include "gtkshell.h"

static void
setup_quit_signal(GtkWindow * window, const gchar * signal)
{
	g_signal_connect(window, signal, G_CALLBACK(gtk_main_quit), NULL);
}

static void
setup_quit_signals(GtkWindow * window)
{
	setup_quit_signal(window, "delete-event");
	setup_quit_signal(window, "destroy");
}


GtkWidget *
gsh_GSH_add_window(struct GSH * gsh)
{
	GtkWidget *window;

	window = gsh->widgets.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	setup_quit_signals(GTK_WINDOW(window));

	return window;
}

void
gsh_GSH_finalize(struct GSH * gsh)
{
	/* Choose the correct parenting of the widget hierarchy based on options
	 * set.  */
	gsh_setup_base_container(gsh);
	/* If geometry has been set in command line arguments, use that, else
	 * use a reasonable default.  */
	gsh_check_and_set_geometry(gsh);
	/* Show everything when ready.  */
	gtk_widget_show(gsh->widgets.window);
}

