/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

extern FILE *yyin, *yyout;
extern struct GDLEnvironment * gsh_guidl_env;

#ifdef DEBUG
static void
print_arguments(const gint argc, const gchar ** argv)
{
	gint i;
	for(i=0; i<argc; i++)
		printf("'%s' ", argv[i]);
	putchar('\n');
}
#endif /* DEBUG */


/* Determine whether or not to include an initial
   dummy argument.  Needed as argv[0] is skipped
   by the command line handling code. */
static void
check_for_dummy_argument(GSH * gsh)
{
	if(!GSH_FLAG(GSH_GUIDL_NO_DUMMY))
		$(gsh_guidl_env->args, add, (const gchar *)"guidl");
}

static void
check_gsh_guidl_env()
{
	if(!gsh_guidl_env)
		gsh_guidl_env=ARNEW(gsh, GDLEnvironment);
}

static void
common_guidl_handler(GSH * gsh)
{
	check_gsh_guidl_env();
	check_for_dummy_argument(gsh);
	yyparse();
	/* Shortcut for specification of arguments.  */
#define GGEA gsh_guidl_env->args
#ifdef DEBUG
	print_arguments(GGEA->argc, GGEA->argv);
#endif /* DEBUG */
	$(gsh, parse, GGEA->argc, (const gchar **)GGEA->argv);
	$(gsh_guidl_env, delete);
	gsh_guidl_env=NULL;
}

static void
guidl_handler_for_file(GSH * gsh, const gchar * filename)
{
	/* If the argument is "-", use stdin for yyin.  */
	/* Otherwise, use FILENAME.  */
	if(strcmp("-", filename))
		yyin=fopen(filename, "r");
	common_guidl_handler(gsh);
}

void
gsh_invalid_option(const gchar ** argv, const gint option)
{
	g_warning("%s:  %s undefined\n", argv[0], argv[option]);
}

#define HANDLE(type)\
	gsh_handle_##type##_arguments(gsh, argc, argv, counter)

void
gsh_handle_switch_arguments(GSH * gsh, const gint argc, const gchar **argv, 
	gint *counter)
{
	$(gsh->rows, check);
	switch (argv[*counter][1])
	{
	case 'a':
		HANDLE(add);
		break;
	case 'd':
		HANDLE(dialog);
		break;
	case 'f':
		GSH_COUNT(argc, counter);
		guidl_handler_for_file(gsh, argv[*counter]);
		break;
	case 'o':
		HANDLE(option);
		break;
	case 't': /* test area.  */
		{
			GtkWidget * parent;
			parent=gtk_event_box_new();
			gsh_swallow_app(parent, "internal");
			$(gsh, manage, parent);
		}
		break;
	default:
		gsh_invalid_option(argv, *counter);
	}
}
