/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


#include "gtkshell.h"

static void
reparent(GtkWidget * widget, GtkWidget * old, GtkWidget * new)
{
	gtk_widget_ref(widget);
	gtk_container_remove(GTK_CONTAINER(old), widget);
	gtk_container_add(GTK_CONTAINER(new), widget);
	gtk_widget_unref(widget);
}

#define REPARENT_TO(new) reparent(gsh->rows->v, gsh->rows->h, new)

static void
split_columns_for_pane(struct GSH * gsh, GtkWidget * pane)
{
	struct GSHRows * rows;

	rows=gsh->rows;
	$(rows, new);
	$(gsh, manage, pane);
	$(rows, new);
}

static GtkWidget *
setup_first_pane_half(struct GSH * gsh, const gchar ** pair)
{
	GtkWidget * first;

	gtk_widget_show(first=gtk_frame_new(pair[0]));
	REPARENT_TO(first);

	return first;
}

static GtkWidget *
setup_second_pane_half(struct GSH * gsh, gchar ** pair)
{
	GtkWidget * second;

	gtk_widget_show(second=gtk_frame_new(pair[1]));
	g_strfreev(pair);
	REPARENT_TO(second);

	return second;
}

static void
assign_pane_sections(GtkWidget * pane, GtkWidget * first, GtkWidget * second)
{
	gtk_paned_add1(GTK_PANED(pane), first);
	gtk_paned_add2(GTK_PANED(pane), second);
}

void
gsh_setup_hpaned(struct GSH * gsh, const gchar * label_pair)
{
	GtkWidget * pane;
	pane=gtk_hpaned_new();
	{
		gchar **pair;

		pair=g_strsplit(label_pair, ",", 2);
		{
			GtkWidget * first;

			first=setup_first_pane_half(gsh, (const gchar **)pair);
			split_columns_for_pane(gsh, pane);
			{
				GtkWidget * second;

				/* PAIR freed here.  */
				second=setup_second_pane_half(gsh, pair);
				assign_pane_sections(pane, first, second);
			}
		}
	}
}


void
gsh_pane_previous(struct GSH * gsh, GtkWidget * target)
{
	GtkWidget * pane;
	GtkWidget * prev_frame;

	pane=gtk_vpaned_new();
	prev_frame = gtk_frame_new(NULL);
#ifdef DEBUG
	ARPASSERT(gsh->widgets.last_managed);
#endif /* DEBUG */
	reparent(gsh->widgets.last_managed, gsh->rows->v, prev_frame);
	assign_pane_sections(pane, prev_frame, target);
	gtk_widget_show(prev_frame);
	gtk_widget_show(target);
	GSH_UNSET(GSH_PANE_NEXT);
	$(gsh, manage, pane);
}
