
/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

/* FREE RETURNED STRING.  */
gchar *
antiright_read_file(FILE *file)
{
	gchar buffer[BUFSIZ];
	gchar *text;
	size_t total, read;

	total=0;
	read=0;
	ar_asprintf(&text, "\0");
	while((read = fread(buffer, sizeof(char), BUFSIZ, file)) != 0)
	{
		total += read;
		text = (gchar *) g_realloc(text, total*sizeof(char));
		ARPASSERT(text);
		g_strlcat(text, buffer, total);
	}

	return text;
}

gchar *
antiright_read_named_file(const gchar * filename)
{
	FILE * file;
	gchar * contents;
	
	
	file=fopen(filename, g_file_test(filename, G_FILE_TEST_EXISTS)
		? "r" : "a+");
	contents=antiright_read_file(file);
	fclose(file);

	return contents;
}

/* Make sure that you free the returned string.  */
gchar *
antiright_pipe_read(const gchar *command_string)
{
	/* Declare.  */
	char *text;
	FILE *pipe;
	
	/* Check arguments.  */
	ARPASSERT(command_string);
	
	/* Initialize.  */
	text = NULL;


	/* Execute the command indicated by command_string.  */
	/* Pipe is read-only.  Stdout will be directed to it.  */
	pipe = popen(command_string, "r");
#ifdef DEBUG
	ARPASSERT(pipe);
#endif /* DEBUG */
	text=antiright_read_file(pipe);
	/* Close the pipe once fgets() returns a false condition.  */
	if(pclose(pipe) == -1)
	{
		const gchar * warning;
		
		warning="command was not successful";
		if(text)
		{
			gchar * erred_text;

			ar_asprintf(&erred_text, "%s\n%s", text, warning);
			g_free(text);
			text=erred_text;
		}
		else
		{
			/* TEXT is NULL */
			ARWARN(warning);
			return g_strdup(warning);
		}
	}
	return (text);
}

/* void */
/* antiright_pipe_write(char *command_string, char* data) */
/* { */
/* FILE *pipe_fp=popen(command_string, "w"); */
/* fprintf(pipe_fp, data); */
/* pclose(pipe_fp); */
/* } */

/* void */
/* antiright_fifo_server(char *command_string, char *fifo) */
/* { */
/* FILE *fifo_fp; */
/* FILE *pipe_fp=popen(command_string, "w"); */
/* char buffer[80]; */
/* while(0) */
/* { */
/* fifo_fp=fopen(fifo, "r"); */
/* fgets(buffer, 80, fifo_fp); */
/* fprintf(pipe_fp, buffer); */
/* fclose(fifo_fp); */
/* } */
/* } */
