/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "xshell.h"

static void
draw_label(XShell * xsh, XWidget * button)
{
	XSHButtonData * data;
	char * label;
	XShellGUI * gui = &(xsh->gui);
	Display * dpy = gui->display;
	GC gc = xsh->gui.gc;

	data=(XSHButtonData *)button->data;
	label=data->label;
	XSH_SET_COLOR(dpy, gc, 0, 0, 0);
	XDrawString(xsh->gui.display, button->window, xsh->gui.gc,
		5, 12, label, strlen(label));
#if 0
{
			unsigned int width, height;
			GC gc = xsh->gui.gc;
			Pixmap pixmap;
			XReadBitmapFile(dpy, button->window,
				"bitmap.xbm", &width, &height,
				&pixmap, NULL, NULL);
			XSH_SET_COLOR(dpy, xsh->gui.gc, 255,255,255);
			XCopyPlane(dpy, pixmap, button->window,
				xsh->gui.gc, 0, 0, width, height, 0, 0, 1); 
			XFreePixmap(dpy, pixmap); 
}
#endif
}

static void
expose(XWidget * button)
{
#ifdef XSH_DECORATE
	if(button->events.button_press)
		xsh_decorate(button, XSH_DECOR_OUT);
	else
		xsh_decorate(button, XSH_DECOR_FLAT);
#endif /* XSH_DECORATE */
	draw_label((XShell *)(button->xsh), button);
}

static void
button_press(XWidget * button)
{
	XSHButtonData * data;

	XMSG("PRESSED");
	data=(XSHButtonData *)button->data;
#ifdef XSH_DECORATE
	xsh_decorate(button, XSH_DECOR_IN);
#endif /* XSH_DECORATE */
	draw_label((XShell *)(button->xsh), button);
	system(data->command);
}

static void
button_release(XWidget * button)
{
	expose(button);
}

static void
configure(XWidget * button)
{
	expose(button);
}

#define SETUP_BUTTON_EVENTS(button)\
	button->events.expose=&expose;\
	button->events.configure=&configure;\
	button->events.key_press=NULL;\
	button->events.button_press=&button_press;\
	button->events.button_release=&button_release;

void
xshell_button_new(XShell * xsh, XWidget * parent, const char * command)
{
	XWidget * button;
	XSHButtonData * data;
	char * label;
	XShellGUILayout *layout=&(xsh->gui.layout);

	xshell_XWidget_new(xsh, parent, 
		XSH_WIDGET_WIDTH*(layout->column_count), 
		XSH_WIDGET_HEIGHT* 
		((layout->row_count = 
		layout->row_count < layout->max_row_count
		? layout->row_count+1:0)-1), 
		XSH_WIDGET_WIDTH, XSH_WIDGET_HEIGHT);
	if(layout->row_count==0)
		layout->column_count++;

	button=xsh->gui.last_widget;
	button->data=data=malloc(sizeof(XSHButtonData));
	data->command=(char *)command;
	data->label=(label=strchr(command, '#'))?label+1:(char*)command;
	SETUP_BUTTON_EVENTS(button);
}


