/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GSH_MACROS_H
#define GSH_MACROS_H

#define GSHBIT(n) 1 << (n-1)

#define GSH_NONE		0
#define GSH_SCROLL 		GSHBIT(1) 
#define GSH_CBEXIT 		GSHBIT(2)
#define GSH_UPDATING		GSHBIT(3)
#define GSH_HORIZONTAL_LABELS	GSHBIT(4)
#define GSH_PROMPT_ECHOES	GSHBIT(5)
#define GSH_FRAMED_LABELS	GSHBIT(6)
#define GSH_MENU_BUTTON		GSHBIT(7)
#define GSH_NO_BASE_FRAME	GSHBIT(8)
#define GSH_NO_EXPAND		GSHBIT(9)
#define GSH_GUIDL_NO_DUMMY	GSHBIT(10)
#define GSH_APP_MODE		GSHBIT(11)
#define GSH_PANE_NEXT		GSHBIT(12)
#define GSH_FIRST_TERMINAL	GSHBIT(13)
#define GSH_TERM_TRANSPARENT	GSHBIT(14)
#define GSH_IN_SECONDARY_WIN	GSHBIT(15)
#define GSH_ICON_SIZE_IS_CUSTOM GSHBIT(16)
#define GSH_CHECK_COMMANDS	GSHBIT(17)

typedef guint Bitmask;

#define GSH_FLAG(flag) ((gsh->bflags & flag) == flag)
#define GSH_SET(flag) gsh->bflags |= flag
#define GSH_UNSET(flag) gsh->bflags &= ~flag

#define GSH_ACTION_IF(action, arg) if(arg) action(arg)
#define GSH_DESTROY_IF(widget) GSH_ACTION_IF(gtk_widget_destroy, widget)
#define GSH_FREE_IF(var) GSH_ACTION_IF(g_free, var)

#define GSH_FIXME() \
	sysprintf("gtkshell -dw '%s:%d: FIXME'",\
		__FILE__, __LINE__)

/* GSH Container Add */
#define GSHCA(container, widget)\
	gtk_container_add(GTK_CONTAINER(container), widget)
/* Add without expansion.  */
#define GSHCA_TIGHT(cont, widget)\
	gtk_box_pack_start(GTK_BOX(cont), widget, FALSE, FALSE, 0);

/* Create and show a widget at the same time.  */
#define GSH_SHOW_CREATE(var, type, ...)\
	gtk_widget_show(var=gtk_##type##_new(__VA_ARGS__))

#define GSHCONNECT(widget, signal, cb, cbdata)\
	g_signal_connect(G_OBJECT(widget), signal, G_CALLBACK(cb), cbdata);

#endif /* not GSH_MACROS_H */

