/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
setup_gui(struct GSH * gsh, const gint argc, const gchar ** argv)
{
	$(gsh, init);
	$(gsh, parse, argc, argv); /* Setup GUI.  */ 
	$(gsh, finalize);
}

int
thread_main(int argc, char **argv)
{
	struct GSH * gsh;

#ifdef LIBGC
	GC_INIT();
#endif /* LIBGC */
	gtk_init(&argc, &argv);
	gsh=ARNEW(gsh, GSH);
	setup_gui(gsh, (const gint)argc, (const gchar **)argv);
#ifdef LIBGC
	GC_gcollect();
#endif /* LIBGC */
	gtk_main(); /* application main loop  */
#ifndef LIBGC
	/* Cleanup when finished.  */
	$(gsh, delete);
#endif /* not LIBGC */

	return (EXIT_SUCCESS);
}

int
main(int argc, char ** argv)
{
	return thread_main(argc, argv);
}
