/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, 
  Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

/* This is for windows that should not be touched by the window manager,
   such as the ACE Deskbar panel.  */
static void
set_no_decorations(GSH * gsh)
{
	/* Alias to minimize dereferences through GSH.  */
	GtkWindow * window;

	/* Recreate main window as popup type.  This is not recommended, but is
	   necessary when using window managers that do not decorate according
	   to hints, such as evilwm.  */
	gsh->widgets.window=gtk_window_new(GTK_WINDOW_POPUP);
	window=GTK_WINDOW(gsh->widgets.window);

	/* GTK WINDOW SET */
#define GWS(attr, ...) gtk_window_set_##attr(window, __VA_ARGS__)
	GWS(type_hint, GDK_WINDOW_TYPE_HINT_DESKTOP);
	GWS(decorated, FALSE);
	GWS(skip_taskbar_hint, TRUE);
	/* Show window on all desktops.  */
	gtk_window_stick(window);
	/* Window does not seem to really accept focus when this is set, most
	   likely because of the POPUP option's side effect of overriding
	   window manager redirection. */
	GWS(accept_focus, TRUE);
}

static void
set_icon_size(GSH * gsh, const gchar * arg)
{
	/* Define some shortcuts.  */
#define GIS gsh->icon_size
	/* GTK_ICON_SIZE_ */
#define GTKIS(size) GTK_ICON_SIZE_##size
	/* Test for gsh->icon_size equality.  */
#define GISCMP(text) !strcmp(text, arg)

#define IFGISCMP(str, siz) if(GISCMP(str)) GIS=GTKIS(MENU);


	if(GISCMP("menu"))
		GIS=GTKIS(MENU);
	else if(GISCMP("small toolbar"))
		GIS=GTKIS(SMALL_TOOLBAR);
	else if(GISCMP("large toolbar") || GISCMP("toolbar"))
		GIS=GTKIS(LARGE_TOOLBAR);
	else if(GISCMP("button"))
		GIS=GTKIS(BUTTON);
	else if(GISCMP("dialog"))       
		GIS=GTKIS(DIALOG);
	else /* default */
		GIS=GTKIS(DND);

	GSH_SET(GSH_ICON_SIZE_IS_CUSTOM);
}

void
gsh_handle_option_arguments(GSH * gsh, const gint argc, const gchar **argv,
	gint *counter)
{
	switch (argv[(*counter)][2])
	{
	case 'a':
		/* Run in application mode.  Here, a menu bar and status
		   bar encloses the application.  This option may also affect
		   other gtkshell properties in the future.  */
		GSH_SET(GSH_APP_MODE);
		break;
	case 'C': 
		/* Check for the existance of a widget's command before
		   displaying an item for it.  */
		GSH_SET(GSH_CHECK_COMMANDS);
		break;
	case 'D':
		/* Do not insert the dummy "guidl" string before the
		   arguments passed by means of a guidl definition.  
		   It is not necessary to include this as an option
		   within the guidl description itself, as the dummy
		   option is inserted prior to parsing.  */
		GSH_SET(GSH_GUIDL_NO_DUMMY);
		break;

	case 'E':		/* Make a text entry simply print the
				 * text.  */
		GSH_SET(GSH_PROMPT_ECHOES);
		break;

	case 'e':
		GSH_SET(GSH_CBEXIT);
		break;

	case 'F':
		GSH_SET(GSH_NO_BASE_FRAME);
		break;

	case 'f':
		GSH_SET(GSH_FRAMED_LABELS);
		break;

	case 'g':
		GSH_COUNT(argc, counter);

		ARIFP(gsh->geometry)
			free(gsh->geometry);

		ar_asprintf(&gsh->geometry, "%s", argv[(*counter)]);

		break;

	case 'h':
		GSH_SET(GSH_HORIZONTAL_LABELS);
		break;
	case 'i':
		GSH_COUNT(argc, counter);
		set_icon_size(gsh, argv[*counter]);
		break;
	case 'l':
		GSH_SET(GSH_NO_EXPAND);
		break;

	case 'L':
		GSH_UNSET(GSH_NO_EXPAND);
		break;

	case 'n': /* no decorations, desktop panel not to be touched by the
		   * window manager.  */
		set_no_decorations(gsh);
		break;

	case 'p': /* Pane next widget with previous.  */
		GSH_SET(GSH_PANE_NEXT);
		break;

	case 'r': /* Set number of rows per column.  */
		GSH_COUNT(argc, counter);
		gsh->rows->total=(unsigned int)atoi(argv[(*counter)]);
		break;

	case 's': /* Use scrolling parent container.  */
		GSH_SET(GSH_SCROLL);
		break;

	case 'T': /* Set the window title.  */
		GSH_COUNT(argc, counter);
		gtk_window_set_title(GTK_WINDOW(gsh->widgets.window),
				argv[*counter]);
		break;

	case 't':
		gsh_handle_terminal_options(gsh, argc, argv, counter);
		break;

	case 'u': /* Set time for updating widgets' timer, in miliseconds.  */
		GSH_COUNT(argc, counter);
		gsh->update->period = atoi(argv[*counter]);
		break;
	}
}

