#!/bin/sh

if [ "$1" == "--help" ]; then
    echo "Usage: autogen.sh [options]"
    echo "Options:"
    echo "--help         : Display this help message"
    echo "--with-errors  : Show verbose information"
    echo ""
    exit;
fi

if [ "$1" == "--with-errors" ]; then
    ERROR="YES"
else
    ERROR="NO"
fi

if autoconf --version > /dev/null 2>&1; then
    
    if autoconf --version | grep '2.[570]' > /dev/null>&1; then
	echo "autoconf   ... yes"
    else
	echo "autoconf   ... no"
	echo "Error: You must have installed a version >= 2.5"
	exit;
    fi
else
    echo "Error: You must have autoconf installed"
    exit;
fi

if automake --version > /dev/null 2>&1; then
   
    if automake --version | grep '1.[567]' > /dev/null>&1; then
	echo "automake   ... yes"
    else
	echo "automake   ... no"
	echo "Error: You must have installed a version >= 1.5"
	exit;
    fi
else
    echo "Error: You must have automake installed"
    exit;
fi

if aclocal --version > /dev/null 2>&1; then
    
    if aclocal --version | grep '1.[567]' > /dev/null>&1; then
	echo "aclocal    ... yes"
    else
	echo "aclocal    ... no"
	echo "Error: You must have installed a version >= 1.5"
	exit;
    fi
else
    echo "Error: You must have aclocal installed"
    exit;
fi

if autoheader --version> /dev/null 2>&1; then
    
    if autoheader --version | grep '2.[5-7]' > /dev/null>&1; then
	echo "autoheader ... yes"
    else
	echo "autoheader ... no"
	echo "Error: You must have installed a version >= 2.5"
	exit;
    fi
else
    echo "Error: You must have autoheader installed"
    exit;
fi

echo "Creating aclocal.m4"
aclocal
echo "Creating config.h.in"
autoheader 
echo "Adding missing standards files to package"
if [ "$ERROR" == "YES" ]; then
    automake --add-missing --copy
else
    automake --add-missing --copy > /dev/null 2>&1;
fi
echo "Creating configure file"
if [ "$ERROR" == "YES" ]; then
    autoconf
else
    autoconf > /dev/null 2>&1;
fi
echo "Now you can run configure script and compile Apolos"
