/*callbacks.c
*
*    Copyright 2003 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<pthread.h>

#include<string.h>
#include<stdlib.h>

#include"types.h"
#include"cddb.h"
#include"callbacks.h"
#include"vol.h"
#include"utils.h"
#include"graf.h"
#include"sound.h"

/*
 * All functions moved here, are considered like a callback
 */


void 
Change_Volume (GtkAdjustment *adj, void * data)
{
  int adj_value;
  Volume *vol;

  vol = (Volume *) data;

  adj_value = (int) gtk_adjustment_get_value (adj); /* I use's a cast because 
						       gtk_adjustment_get_value () return a double 
						     */

  vol->left = adj_value;
  vol->right = adj_value;
 
  Set_Volume (vol);
}

void
select_server (GtkTreeSelection * selection, gpointer data)
{
  GtkTreePath *path;
  GtkTreeView *tree;
  GtkTreeModel *model;
  GtkTreeIter iter;
  Server *Sites;
  Datos *cd;
  int i, server;

  cd = (Datos *) data;

  tree = gtk_tree_selection_get_tree_view (selection);
  model = gtk_tree_view_get_model (tree);
  gtk_tree_selection_get_selected (selection, &model, &iter);
  path = gtk_tree_model_get_path (model, &iter);

  server = atoi (gtk_tree_path_to_string (path));

  Sites = cd->cddb->Servers;

  for (i = 0; i < server; i++)
    Sites = Sites->next;
  gtk_entry_set_text (GTK_ENTRY (cd->cddb->entry), Sites->host);
}

void
Look_Up_Servers (GtkWidget * widget, gpointer data)
{
  pthread_t threadp;
  pthread_attr_t thread_attr;
  DatosCD *datos;

  datos = (DatosCD *)data;

  pthread_attr_init (&thread_attr);
  pthread_attr_setdetachstate (&thread_attr, PTHREAD_CREATE_JOINABLE);
  pthread_create (&threadp, &thread_attr, Servers, (void *)datos);
  pthread_join(threadp, NULL);
  pthread_attr_destroy (&thread_attr);

  List_Servers (data);
}

void
Cerrar (GtkWidget * widget, gpointer data)
{
  GtkWidget *win;

  win = (GtkWidget *) data;

  gtk_widget_destroy (win);
}

void
select_row (GtkWidget *widget, GdkEventButton *event, void *data)
{
  DatosCD *datos = (DatosCD *) data;
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;
  GtkTreePath *path;
  GtkTreeSelection *select;
  
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (graf->tree));
  gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW (graf->tree), 
				 event->x, event->y,
				 &path, 0, 0, 0);

  gtk_tree_selection_select_path (select, path);

  if (event->type == GDK_2BUTTON_PRESS)
    cd->tocando = TRUE;

  cd->track = 1 + atoi (gtk_tree_path_to_string (path));

  cd->trackactual = Find_Track(cd, cd->track);

  change_main_title (graf, cd);
  if (cd->tocando == TRUE)
    play_cd (NULL, (void *) datos);
}

void
destruir_winlist (GtkWidget * widget, gpointer data)
{
  DatosCD *datos;

  datos = (DatosCD *) data;

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (datos->graf->boton_lista),
				FALSE);
  datos->cd->lista = FALSE;
  gtk_widget_destroy (widget);
}

void
Barajado (GtkWidget * widget, gpointer data)
{
  Datos *cd;

  cd = (Datos *) data;

  if (cd->barajado == TRUE)
    cd->barajado = FALSE;
  else if (cd->barajado == FALSE)
    cd->barajado = TRUE;

}

void
Repeat (GtkWidget * widget, gpointer data)
{
  Datos *cd = (Datos *) data;

  if (cd->repeat == TRUE)
    cd->repeat = FALSE;
  else if (cd->barajado == FALSE)
    cd->repeat = TRUE;
}

void
Close_Main_Win (GtkWidget * widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  salir (datos);
}

/* This function was made to replace the old salir() function */
void 
quit (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;

  salir (datos);
}

/* The following functions are callbacks, was made to work with the CD */

void
play_cd (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  if (datos->cd->existcd == FALSE)
    return;
 
  tocar_track (datos->cd);
  draw_barra (datos->graf, datos->cd);
}

void
stop_cd (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  if (datos->cd->existcd == FALSE)
    return;

  kill_adjustment (datos->graf);
  parar (datos->cd);
}

void 
next_track (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  if (datos->cd->existcd == FALSE)
    return;

  siguiente (datos);
}

void
back_track (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  if (datos->cd->existcd == FALSE)
    return;
   
  atras (datos);
}

void
eject_cd (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  eject (datos->cd);
}

void
pause_track (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;

  if (datos->cd->existcd == FALSE)
    return;  

  pausa (datos->cd);
}

/* The following funtions are callbacks and was made to work with GtkItemFactory. */
/* These callbacks operates in the menu */

void
menu_play (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;

  tocar_track (datos->cd);
  draw_barra (datos->graf, datos->cd);
}

void 
menu_stop (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;
  
  parar (datos->cd);
}

void
menu_back (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;

  atras (datos);
}

void 
menu_next (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;

  siguiente (datos);
}

void
menu_pause (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *)data;
  
  pausa (datos->cd);
}

void
menu_eject (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;

  eject (datos->cd);
}

void
menu_CDDB (gpointer data, unsigned int action, GtkWidget * widget)
{
  Look_Up_CDDB(NULL, data);
}

void
menu_Check (gpointer data, unsigned int action, GtkWidget *widget)
{
  //  Check_Disc ( data);
  thread_check_disc (NULL, data);
}

void
Change_check_button (GtkWidget *widget, gpointer data)
{
  char *text = (char *) data;

  if (strcmp(text, "1") == 0)
    strcpy(text, "0");
  else
    strcpy(text, "1");
}

void
play_from (GtkAdjustment *adj, gpointer data)
{
  int current_secs;
  char *buffer = (char *) calloc (5, sizeof (char *));
  double value;
  DatosCD *datos = (DatosCD *) data;
  Datos *cd = datos->cd;
  Graf *graf = datos->graf;

  value = gtk_adjustment_get_value (GTK_ADJUSTMENT (adj));

  current_secs = cd->trans_sec +
    (cd->trans_minutos * 60);

  if (current_secs != (int) value)
    {
      g_snprintf (buffer, 10, "%02d:%02d", cd->trans_minutos, cd->trans_sec);
      gtk_label_set_text (GTK_LABEL (graf->label_time), buffer);
      play_track_from (cd, (int)value);
    }
}
void
thread_check_disc (GtkWidget *widget, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;
  
  pthread_create (&(datos->cd->check_disc_thread), NULL, (void *)Check_Disc, (void *)datos);
  //  Check_Disc ( (void *) datos);
}

/* Toggle the play box */
void
play_toggled (GtkCellRendererToggle *toggle, char *path_str, gpointer data)
{
  DatosCD *datos = (DatosCD *) data;
  Graf *graf = datos->graf;
  gboolean value;
  GtkTreeModel *model = (GTK_TREE_MODEL (graf->treestore));
  GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
  GtkTreeIter iter;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 0, &value, -1);

  if (value == 0)
    {      
      value = 1;
      play_set_value (value, atoi (path_str)+1, datos);
    }
  else
    {
      value = 0;
      play_set_value (value, atoi (path_str)+1, datos);      
    }
  gtk_tree_store_set (GTK_TREE_STORE (model), &iter, 0, value);
    
  gtk_tree_path_free (path);
}

/*

The following callbacks all are have a relation with rip mode 

 */

/* Rip the track ?*/

void
rip_toggled (GtkCellRendererToggle *toggle, char *path_str, gpointer data)
{
  gboolean value;
  DatosCD *datos = (DatosCD *) data;
  Graf *graf = datos->graf;
  GtkTreeModel *model = (GTK_TREE_MODEL (graf->treestore));
  GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
  GtkTreeIter iter;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 4, &value, -1);

  if (value == 0)
    {
      value = 1;
      rip_set_value (value, atoi (path_str)+1, datos);
    }
  else
    {
      value = 0;
      rip_set_value (value, atoi (path_str)+1, datos);
    }

  gtk_tree_store_set (GTK_TREE_STORE (model), &iter, 4, value);

  gtk_tree_path_free (path);

}

void
start_rip (gpointer data, unsigned int action, GtkWidget * widget)
{
  DatosCD *datos = (DatosCD *) data;

  
  rip (datos, 1);

}

/*
  To update the sound :)
  Thanks Solymos
 */

int
sound_update (gpointer data)
{
  DatosCD *datos = (DatosCD *) data;
  Graf *graf = datos->graf;
  Vols *vols = datos->vols;

  update_cdrom (datos);
  
  Get_Volume (vols);

  gtk_adjustment_set_value ( GTK_ADJUSTMENT (graf->adj_vol), vols->vol->left);
  gtk_adjustment_set_value ( GTK_ADJUSTMENT (graf->adj_cd), vols->cdrom->left);
  
  return TRUE;
}
