/*sound.c
*
*    Copyright 2002 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include"../config.h"

#ifdef HAVE_LINUX_CDROM_H
#include<linux/cdrom.h>
#endif

#include<sys/ioctl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<unistd.h>
#include<stdio.h>
#include<string.h> /* Strings header */
#include<stdlib.h>
#include<errno.h> /* Header to the posibles error */
#include<time.h> /* time(2) to user with srand(3) */ 

#include<pthread.h> /* Only to use the function pthread_exit() in Check_Disc */

#include"types.h"
#include"sound.h"
#include"graf.h"
#include"utils.h"
#include"cddb.h"

void
tocar_track (Datos *cd)
{
  struct cdrom_msf msf;
  int ret;

  if (cd->existcd == FALSE)
    return;

  if (cd->pausa == FALSE)

    {
      cd->trackactual = Find_Track (cd, cd->track);

      msf.cdmsf_min0 = cd->trackactual->offset->minutos;
      msf.cdmsf_sec0 = cd->trackactual->offset->sec;
      msf.cdmsf_frame0 = cd->trackactual->offset->frame;
      
      if (cd->track != cd->total_track)
	{
	  msf.cdmsf_min1 = cd->trackactual->next->offset->minutos;
	  msf.cdmsf_sec1 = cd->trackactual->next->offset->sec;
	  msf.cdmsf_frame1 = cd->trackactual->next->offset->frame;
	}
      else
	{
	  msf.cdmsf_min1 = cd->Disco->offset->minutos;
	  msf.cdmsf_sec1 = cd->Disco->offset->sec;
	  msf.cdmsf_frame1 = cd->Disco->offset->frame;
	}

      ret = ioctl (cd->fd, CDROMPLAYMSF, &msf);
      if(ret == -1)
	{
	  Error (strerror (errno), "Playing");
	  return;
	}
      cd->tocando = TRUE;
    }
  else
    {
      ioctl (cd->fd, CDROMRESUME);
      cd->pausa = FALSE;
    }
}

void
play_track_from (Datos *cd, int barr_secs)
{
  int ret;
  int minutos, secs;
  struct cdrom_msf msf;

  minutos = barr_secs / 60;
  secs = barr_secs % 60;
  
  cd->trans_minutos = minutos;
  cd->trans_sec = secs;

  msf.cdmsf_min0 = cd->trackactual->offset->minutos + minutos;
  msf.cdmsf_sec0 = cd->trackactual->offset->sec + secs;

  if (cd->track != cd->total_track)
    {
      msf.cdmsf_min1 = cd->trackactual->next->offset->minutos;
      msf.cdmsf_sec1 = cd->trackactual->next->offset->sec;
      msf.cdmsf_frame1 = cd->trackactual->next->offset->frame;
    }
  else
    {
      msf.cdmsf_min1 = cd->Disco->offset->minutos;
      msf.cdmsf_sec1 = cd->Disco->offset->sec;
      msf.cdmsf_frame1 = cd->Disco->offset->frame;
    }

  ret = ioctl (cd->fd, CDROMPLAYMSF, &msf);
}

void
salir (DatosCD * datos)
{
  Datos *cd = datos->cd;

  if (cd->tocando == TRUE)
    {
      if (ioctl (cd->fd, CDROMSTOP) == -1)
	Error (strerror(errno), "Stop");
    } 
    
  free_all_memory (datos);

  gtk_main_quit ();
  exit (0);
}

int
parar (Datos *cd)
{
  int ret;

  if (cd->tocando == FALSE)
    return 0;
   
  ret = ioctl (cd->fd, CDROMSTOP);
  if (ret == -1)
    Error (strerror (errno), "Stop");
    
  cd->tocando = FALSE;
  cd->trans_minutos = 0;
  cd->trans_sec = 0;

  return 0;
}

int
siguiente (DatosCD *datos)
{
  char buf[10];
  GtkTreeSelection *selection;
  GtkTreePath *path;
  Graf *graf;
  Datos *cd;

  graf = datos->graf;
  cd = datos->cd;

  if (cd->existcd == FALSE)
    return 0;

  cd->trans_minutos = 0;
  cd->trans_sec = 0;

  if (cd->barajado == TRUE)
    {
      random_track (cd);
      cd->track = cd->siguiente_track;
    }
  else
    cd->track += 1;

  if (cd->track > cd->total_track)
    {
      if (cd->repeat == FALSE)
	parar (cd);
      else
	cd->track = 1;
    }
  cd->trackactual = Find_Track (cd, cd->track);

  if (cd->trackactual->play != TRUE)
    siguiente (datos);
  
  if (cd->track <= cd->total_track)
    {
      if (cd->lista == TRUE)
	{
	  snprintf (buf, 10, "%d", cd->track - 1);
	  path = gtk_tree_path_new_from_string (buf);
	  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (graf->tree));
	  gtk_tree_selection_select_path (selection, path);
	}
    }

  change_main_title (graf, cd);
  
  if (cd->tocando == TRUE)
    {
      tocar_track (cd);
      draw_barra (graf, cd);
    }
  update (datos);

  return 0;
}

int
atras (DatosCD *datos)
{
  int temp; /* Save the possible track to play*/
  char buf[4];
  GtkTreePath *path;
  GtkTreeSelection *selection;
  Datos *cd;
  Graf *graf;

  cd = datos->cd;
  graf = datos->graf;

  if (cd->existcd == FALSE) /* If dosen't exist a cd */
    return 0;

  cd->trans_minutos = 0;
  cd->trans_sec = 0;

  temp = cd->track - 1;

  if (temp > 0)
    cd->track -= 1;

  if (cd->tocando == TRUE)
    {
      tocar_track (cd);
      draw_barra (graf, cd);
    }
  if (cd->lista == TRUE) /* If the tracklist it's displayed*/
    {
      snprintf (buf, 4, "%d", cd->track - 1);
      path = gtk_tree_path_new_from_string (buf);
      selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (graf->tree));
      gtk_tree_selection_select_path (selection, path);
    }
  
  cd->trackactual = Find_Track (cd, cd->track); /* We refresh the trackactual with the new info track*/

  change_main_title (graf, cd); /* We change the title on the main window*/

  update (datos); 

  return 0;
}

int
eject (Datos *cd)
{
  int ret;

  if (cd->fd == -1)
    open_fd (cd);

  if (cd->cdopen == FALSE)
    {
      if (ioctl (cd->fd, CDROMEJECT) >= 0)
	cd->cdopen = TRUE;
      else
	Error (strerror (errno), "Eject");
    }
  else
    { 
      ret = ioctl (cd->fd, CDROMCLOSETRAY);
      if (ret != -1)
	cd->cdopen = FALSE;
      else
	Error (strerror (errno), "Close");
    }

  return 0;
}

int
pausa (Datos *cd)
{
  int ret;

  if (cd->existcd == FALSE)
    return 0;

  if (cd->pausa == TRUE)
    {
      ret = ioctl (cd->fd, CDROMRESUME);
      if (ret != -1)
	cd->pausa = FALSE;
      else
	Error (strerror (errno), "Resume");
    }
  else if (cd->pausa == FALSE)
    {
      ret = ioctl (cd->fd, CDROMPAUSE);
      if (ret != -1)
	cd->pausa = TRUE;
      else
	Error (strerror (errno), "Pause");
    }
  
  return 0;
}

int
ListaTracks (Datos * cd)
{
  struct cdrom_tochdr cdtoc;

  ioctl (cd->fd, CDROMREADTOCHDR, &cdtoc);

  return cdtoc.cdth_trk1;
}

int
Cal_Time (Datos * cd)
{
  struct cdrom_tocentry centry;
  int temp;
  int i;


  for (i = 0; i <= cd->total_track; i++)
    {
      if (i == cd->total_track)
	centry.cdte_track = CDROM_LEADOUT;
      else
	centry.cdte_track = i + 1;

      centry.cdte_format = CDROM_MSF;
      if (ioctl (cd->fd, CDROMREADTOCENTRY, &centry) == -1)
	{
	  Error (_("Can't read the track"), _("Playing Track"));
	  return 1;
	}
   
      cd->tracklist->offset->minutos = centry.cdte_addr.msf.minute;
      cd->tracklist->offset->sec = centry.cdte_addr.msf.second;
      cd->tracklist->offset->frame = centry.cdte_addr.msf.frame;
    
      if (cd->tracklist->next != cd->header)
	cd->tracklist = cd->tracklist->next;
    }

  cd->Disco->offset->minutos = cd->tracklist->offset->minutos;
  cd->Disco->offset->sec = cd->tracklist->offset->sec;

  cd->tracklist = cd->header;

  for (i = 0; i < cd->total_track; i++)
    {
      temp = 0;
      temp =
	cd->tracklist->offset->frame +
	cd->tracklist->offset->sec * CD_FRAMES +
	cd->tracklist->offset->minutos * CD_SECS * CD_FRAMES;

      cd->tracklist = cd->tracklist->next;

      temp =
	cd->tracklist->offset->frame +
	cd->tracklist->offset->sec * CD_FRAMES +
	cd->tracklist->offset->minutos * CD_SECS * CD_FRAMES - temp;

      cd->tracklist->back->time->minutos = temp / (CD_SECS * CD_FRAMES);
      temp %= CD_SECS * CD_FRAMES;

      cd->tracklist->back->time->sec = temp / CD_FRAMES;
      cd->tracklist->back->time->frame = temp % CD_SECS;
    }

  cd->Disco->time->minutos = cd->tracklist->offset->minutos;
  cd->Disco->time->sec = cd->tracklist->offset->sec;
  cd->Disco->time->frame = cd->tracklist->offset->frame;
  cd->tracklist = cd->header;


  for (i = 0; i <= cd->total_track; i++)
    {
      cd->tracklist->start->frame =
	(cd->tracklist->offset->minutos * CD_SECS +
	 cd->tracklist->offset->sec) * CD_FRAMES +
	cd->tracklist->offset->frame;

      if (cd->tracklist->next != cd->header)
	cd->tracklist = cd->tracklist->next;
    }

  cd->tracklist->back->next = cd->header;
  cd->tracklist = cd->header;

  return 0;
}

void
acero (Datos * cd)
{
  cd->header = NULL;
  cd->tracklist = NULL;
  cd->Disco = NULL;
  cd->trackactual = NULL;
}

void
random_track (Datos * cd)
{
  srand (time (0));

  cd->siguiente_track = rand () % cd->total_track;
}

int
check_cd (Datos * cd)
{
  int ret;

  ret = ioctl (cd->fd, CDROM_DRIVE_STATUS);
  if (ret == CDS_DISC_OK) /* If disc it's ok*/ 
    {
      ret = ioctl (cd->fd, CDROM_DISC_STATUS);
      if (ret == CDS_AUDIO) /* If the disc it's an audio cd*/ 
	return TRUE; /* We have an audio cd in the cdrom */
      else
	return FALSE;
    }
  else
    return FALSE;

}

void *
Check_Disc (void * data)
{
  int ret;
  DatosCD *datos = (DatosCD *) data;
  Datos *cd = datos->cd;
  Graf *graf = datos->graf;

  if (cd->checkin_disc != FALSE)
    pthread_exit (NULL);
  else
    cd->checkin_disc = TRUE;

  MSG_to_Statusbar(graf, _("Checking Disc..."));

  if (cd->existcd == TRUE)
    {
      //      free_lista (cd);
      acero (cd);
    }
  
    if (cd->fd != -1)
      {
	
      open_fd (cd); /* One function works much better than repeat the same code :)*/

      if (cd->fd == -1)
	pthread_exit (NULL);
      
      ret = check_cd (cd);
      if (ret == TRUE) /* TRUE: exist cd */
	{
	  cd->existcd = TRUE;
	  complet (cd);	
	}
      else
	{
	  cd->existcd = FALSE;
	  /*	  close (cd->fd);
		  cd->fd = -1;*/
	}
      
      update (datos);

    }
  else
    {
      open_fd (cd);
      
      if (cd->fd == -1)
	pthread_exit (NULL);

      ret = check_cd (cd);
      if (ret == TRUE) /* TRUE: exist cd */
	{
	  cd->existcd = TRUE;
	  complet (cd);	
	}
      else
	{
	  cd->existcd = FALSE;
	  /*	  close (cd->fd);
		  cd->fd = -1;*/
	}
    }

    if (atoi (cd->cddb->autocheck) == TRUE && cd->existcd == TRUE)
      Look_Up_CDDB (NULL, (gpointer) datos);

  /* This way it's much better than the other way */
  gtk_widget_set_sensitive (graf->boton_lista, cd->existcd);
  gtk_widget_set_sensitive (graf->boton_barajado, cd->existcd);
  gtk_widget_set_sensitive (graf->boton_repeat, cd->existcd);

  /* We need to make an update to the playlist */
  /* Bug report by: David Leemans */

  if (cd->lista == TRUE && cd->existcd == TRUE)
    {
      update_playlist (datos);
    }
  
  MSG_to_Statusbar(graf, _("Done."));

  /* We back the variable to false */
  cd->checkin_disc = FALSE;

  pthread_exit(0);
}

int
open_fd (Datos *cd)
{
  if (cd->fd != -1) /* If exist a previus file descriptor open we close it */
    close (cd->fd);

  cd->fd = open (cd->cd_device, O_RDONLY | O_NONBLOCK);

  if (cd->fd == -1)
    Error (strerror (errno), "Open File Descriptor"); 
    
  return cd->fd;
}

int
update_cdrom (DatosCD *datos)
{
  struct cdrom_subchnl subchnl;
  int ret;
  Datos *cd = datos->cd;
  Graf *graf = datos->graf;

  /*  if (cd->existcd == FALSE || cd->cdopen == TRUE)
      return 0;*/
  
  ret = ioctl (cd->fd, CDROM_DRIVE_STATUS);
  
  switch (ret)
    {
    case -1:
    case  CDS_DISC_OK:
      if (cd->existcd == TRUE)
	break;
      subchnl.cdsc_format = CDROM_MSF;
      ioctl (cd->fd, CDROMSUBCHNL, &subchnl);
      /* We just need to know if the disk in the unit it's an audio cd :)*/
      if (subchnl.cdsc_audiostatus == CDROM_AUDIO_NO_STATUS)
	return 0;
      if (cd->existcd == FALSE)
	thread_check_disc (NULL, (void *)datos);            
      return 0;
    case CDS_TRAY_OPEN:
      if (cd->existcd == TRUE)
	  thread_check_disc (NULL, (void *)datos);	
      break;
    }

  subchnl.cdsc_format = CDROM_MSF;
  if ( (ioctl (cd->fd, CDROMSUBCHNL, &subchnl)) < 0)
    {
      Error (strerror (errno), _("Trying to get the cdrom information"));
      return 0;
    }
 
  switch (subchnl.cdsc_audiostatus)
    {
    case CDROM_AUDIO_PLAY:
      if (cd->tocando != TRUE)
	cd->tocando = TRUE;
      if (cd->barra == FALSE)
	draw_barra (graf, cd);
      cd->tocando = TRUE;
      set_time (graf, cd, subchnl.cdsc_reladdr.msf.minute, subchnl.cdsc_reladdr.msf.second);
      break;
    case CDROM_AUDIO_NO_STATUS:
      if (cd->tocando == TRUE)
	cd->tocando = FALSE;
      if (cd->barra == TRUE)
	kill_adjustment (datos->graf);
      datos->cd->barra = FALSE;
      cd->tocando = FALSE;
      break;
    case CDROM_AUDIO_COMPLETED:
      siguiente (datos);
      break;
    default:
      break;
    }  

  return 0;
}

gint
play_set_value (gboolean value, gint track, DatosCD *datos)
{
  Tracklist *tracklist = Find_Track (datos->cd, track);

  tracklist->play = value;

  return 0;
}

gint
rip_set_value (gboolean value, gint track, DatosCD *datos)
{
  Tracklist *tracklist = Find_Track (datos->cd, track);

  tracklist->rip = value;

  return 0;
}
