/*rip.c
*
*    Copyright 2002 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/*
The code on this page doesn't work if you want you can help :)
I have to say, the lines and the names of the variables are like 
that in main.c of cdparanoia. I hope and I want to change the code 
to create a better way :)
*/

#include"types.h"
#include"utils.h"

#include<stdio.h>
#include<stdlib.h>
#include<fcntl.h>
#include<unistd.h>


#include<cdda_interface.h>
#include<cdda_paranoia.h>

void WriteWav (int fd, long bytes); /* Write the header of the wav file */

int buffer_write (int fd, char *buffer, long num); /* Write the 'data' in wav file */

gchar *
make_file_name (Tracklist *tracklist)
{
  gchar *file_name = (gchar *) calloc (250, sizeof (gchar *));
  
  g_snprintf (file_name, 250, "%s - %s", tracklist->artista->texto, tracklist->titulo->texto);

  return file_name;
}

gint 
rip (DatosCD *datos, gint track)
{
  gchar *file_name = (gchar *) calloc (250, sizeof (gchar *));
  Tracklist *tracklist = Find_Track (datos->cd, track);

  if (tracklist->rip != TRUE && track+1 != datos->cd->total_track)
    {
      rip (datos, track+1);
    }
  else
    {
      g_snprintf (file_name, 250, "%s/%s", datos->rip->temp_files, make_file_name (tracklist));
      rip_track (tracklist, datos->cd, datos->rip, file_name);
    }

  return 0;
}

gint 
rip_track (Tracklist *tracklist, Datos *cd, Rip *rip, gchar *file_name)
{
  int ret;
  int out_fd;
  int mode = PARANOIA_MODE_FULL^PARANOIA_MODE_NEVERSKIP;
  int16_t *readbuf;
  long first_sector, last_sector, cursor;
  long batch_first, batch_last;
  long call_begin, call_end;
  gchar *file_name_out = (char *) calloc (255, sizeof (char *)); /* 255 it's the max size of a filename ?*/
  cdrom_drive *d;/*    This name are the sames of */
  cdrom_paranoia *p;/* cdparanoia.c in cdparanoia */


  g_snprintf (file_name_out, 255, "%s.wav", file_name);

  /*
    We identify the type of device and if we have access.
    If we can't access the device cdda_identify return NULL.
    This part of the code it's fine for the moment, but 
   */
  d = cdda_identify (cd->cd_device, CDDA_MESSAGE_PRINTIT, NULL);
  
  if (d == NULL)
    {
      printf ("error\n");
      exit (1);
    }

  cdda_verbose_set ( d, CDDA_MESSAGE_PRINTIT,  CDDA_MESSAGE_PRINTIT);

  paranoia_init (d); 
  
  ret = cdda_open (d); 
  
  first_sector = cdda_track_firstsector (d, 1);
  last_sector = cdda_track_lastsector (d, 1);
  
  p = paranoia_init (d); 
  
  paranoia_modeset (p, mode);
  
  cdda_verbose_set(d,CDDA_MESSAGE_LOGIT,CDDA_MESSAGE_LOGIT);
  
  paranoia_seek(p,cursor=first_sector,SEEK_SET);
  
  while (cursor <= last_sector) /* We check all sectors*/
    {
      batch_first = cursor;
      batch_last = cdda_track_lastsector (d, 1);
      
      call_begin = batch_first;
      call_end = batch_last;
       
      out_fd = open (file_name_out,O_RDWR|O_CREAT|O_TRUNC,0666);
      
      WriteWav (out_fd, (batch_last-batch_first+1)*CD_FRAMESIZE_RAW);

      while (cursor <= batch_last)
	{
	  readbuf = paranoia_read_limited (p, NULL, 20); /* We can/should the NULL by a function */
	  
	  buffer_write (out_fd, (char *)readbuf, CD_FRAMESIZE_RAW);
	  cursor++;
	}
    }
  
  close (out_fd);
  ret = cdda_close (d);
  
  paranoia_free (p);
  return 0;
}

void
WriteWav (int fd, long bytes)
{
  struct __wav {
    /* RIFF header */
    unsigned char id[4];
    unsigned long int len;
    
    /* WAVE header */
    unsigned char type[4]; /* RIFF type, in this case is WAVE */
    unsigned char fmt[4]; /* 'fmt ' */
    
    unsigned long int format; /* 16-bits or 8-bits */
    unsigned short int formatcat; /* 0x001 (1) if is a WAVE PCM */
    
    unsigned short int channels; /* Channels */
    unsigned long int samplepersec; /* Sample per Sec */
    unsigned long int bytespersec; /* Bytes per Sec  */
    unsigned short int blockalign; /* Block align */
    unsigned short int bitspersample; /* Bits per Sample */

    unsigned char data[4]; /* 'data' */
    unsigned long int wave_data; /* WAVE data */
  } wav;

  sprintf (wav.id, "RIFF");
  wav.len = bytes+36; /* 36 are the bytes of the WAVE header */
  sprintf (wav.type, "WAVE");
  sprintf (wav.fmt, "fmt ");
  wav.format = 16;
  wav.formatcat = 1; /* in hexadecimal is: 0x0001 */
  wav.channels = 2;
  wav.samplepersec = 44100;
  wav.bytespersec = 44100*2*2;
  wav.blockalign = 4;
  wav.bitspersample = 16;
  sprintf (wav.data, "data");
  wav.wave_data = bytes;

  write (fd, &wav, sizeof (wav));

}

int
buffer_write (int fd, char *buffer, long num)
{
  write (fd, buffer, num);

  return 0;
}
