/*vol.c
*
*    Copyright 2003 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "../config.h"

#ifdef HAVE_LINUX_SOUNDCARD_H
#include<linux/soundcard.h>
#endif

#include<sys/ioctl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<unistd.h>
#include<errno.h>

#include<string.h> /* To use strerror() */

#include"vol.h"
#include"graf.h"

void 
Assign_Memory (Vols *vols)
{
  
  vols->vol = (Volume *) malloc (sizeof  (Volume));
  vols->vol->macro = SOUND_MIXER_VOLUME;

  vols->cdrom = (Volume *) malloc (sizeof (Volume));
  vols->cdrom->macro = SOUND_MIXER_CD;
}

void 
Get_Volume (Vols *vols)
{
  int fd_sound; /* File Descriptor to use with open */
  int i, ret_ioctl;
  int volume;
  Volume *vol[] = { 
    vols->cdrom, 
    vols->vol 
  };

  fd_sound = open ("/dev/mixer", O_RDONLY);

  for (i = 0; i < (sizeof (vol) / sizeof (vol[0])); i++)
    {
      ret_ioctl = ioctl (fd_sound, MIXER_READ (vol[i]->macro), &volume);

      if (ret_ioctl == -1)
	return;
      else
	{
	  vol[i]->left = (volume & LEFT_MASK);
	  vol[i]->right = (volume & RIGHT_MASK) >> 8;
	}
    }

  close (fd_sound);
}

void 
Set_Volume (Volume *vol)
{
  int fd_sound; /* File Descripto to use with open */
  int ret_ioctl;
  int volume;

  fd_sound = open ("/dev/mixer", O_WRONLY);

  if (fd_sound == -1)
    {
      Error (strerror (errno), _("Open device"));
      return;
    }
  volume = vol->left + (256 * vol->right);
  
  ret_ioctl = ioctl (fd_sound, MIXER_WRITE(vol->macro), &volume);

  if (ret_ioctl == -1)
    Error (strerror (errno), _("Setting Volume"));
  
  close (fd_sound);
}
