/*encode.c
*
*    Copyright (C) 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include"types.h"

#include"rip.h"

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<fcntl.h>
#include<time.h>
#include<math.h>
#include<glib.h>
#include<vorbis/codec.h>
#include<vorbis/vorbisenc.h>

/*
 * We just enconde in OGG format
 */

/*
 * The code in the follow functions was take it from the ogg examples
 * Well, I should make a better code, but for a while it's would be a good
 * idea use this way
 */

#define READ 1024
signed char readbuffer[READ * 4 + 44];

FILE *in = NULL, *out = NULL;

gint
Encode (DatosCD *datos, Tracklist *tracklist)
{
  int eos=0;
  int i, founddata;
  
  vorbis_info info;
  vorbis_comment vorbis_comments;
  vorbis_dsp_state vd;
  vorbis_block vb;
  
  ogg_stream_state os; /* take physical pages, weld into a logical
			  stream of packets */
  ogg_page         og; /* one Ogg bitstream page.  Vorbis packets are inside */
  ogg_packet       op; /* one raw packet of data for decode */
  
  in = fopen (g_strdup_printf ("%s/%s.wav", datos->rip->temp_files, make_file_name (tracklist)), "rb");
  
  readbuffer[0] = '\0';
  for (i=0, founddata=0; i<30 && ! feof (in) && ! ferror (in); i++)
    {
      fread (readbuffer,1,2,in);
      
      if (!strncmp ((char*) readbuffer, "da", 2) )
	{
	  founddata = 1;
	  fread(readbuffer,1,6,in);
	  break;
	}
    }
  
  vorbis_info_init (&info);
  
  vorbis_encode_init_vbr (&info, 2, 44100, .5);
  
  vorbis_comment_init (&vorbis_comments);
  /* We set the names artist and all that things in the ogg file */
  vorbis_comment_add_tag (&vorbis_comments, "Title", tracklist->titulo->texto);
  vorbis_comment_add_tag (&vorbis_comments, "Artist", tracklist->artista->texto);
  vorbis_comment_add_tag (&vorbis_comments, "Album", datos->cd->Disco->titulo->texto);
  vorbis_comment_add_tag (&vorbis_comments, "Genre", datos->cd->Disco->estilo);
  
  vorbis_analysis_init (&vd, &info);
  vorbis_block_init (&vd, &vb);  
  
  srand (time (NULL));
  ogg_stream_init (&os, rand());
  
  out = fopen(g_strdup_printf ("%s/%s.ogg", datos->rip->ripped_files, make_file_name (tracklist)), "wb");
  
  {
    ogg_packet header;
    ogg_packet header_comm;
    ogg_packet header_code;

    vorbis_analysis_headerout (&vd, &vorbis_comments, &header, &header_comm, &header_code);
    ogg_stream_packetin (&os, &header);

    ogg_stream_packetin (&os, &header_comm);
    ogg_stream_packetin (&os, &header_code);

    while (!eos)
       {
	 int result = ogg_stream_flush (&os, &og);
	 
	 if (result == 0) 
	   break;
	 
	fwrite (og.header, 1, og.header_len, out);
	fwrite (og.body, 1, og.body_len, out);
      }
  }
  
  while (!eos)
    {
      long i;
      long bytes = fread (readbuffer, 1, READ * 4, in);

      if (bytes == 0)
	vorbis_analysis_wrote (&vd, 0);
      else
	{
	  float **buffer = vorbis_analysis_buffer (&vd, READ);

	  for (i = 0; i < bytes / 4; i++)
	    {
	      buffer[0][i]=((readbuffer[i*4+1]<<8)|
			    (0x00ff&(int)readbuffer[i*4]))/32768.f;
	      buffer[1][i]=((readbuffer[i*4+3]<<8)|
			    (0x00ff&(int)readbuffer[i*4+2]))/32768.f;

	    }
	  
	  vorbis_analysis_wrote (&vd, i); 
	}

      while (vorbis_analysis_blockout (&vd, &vb) == 1)
	{
	  vorbis_analysis (&vb, NULL);
	  vorbis_bitrate_addblock (&vb);

	  while (vorbis_bitrate_flushpacket (&vd, &op))
	    {
	      ogg_stream_packetin (&os, &op);
	      
	      while (!eos)
		{
		  int result=ogg_stream_pageout (&os, &og);
		  if (result == 0)
		    break;
		  fwrite (og.header, 1, og.header_len, out);
		  fwrite (og.body, 1, og.body_len, out);
		  
		  if (ogg_page_eos (&og))
		    eos = 1;
		}
	    }
	}
    }

  ogg_stream_clear (&os);
  vorbis_block_clear (&vb);
  vorbis_dsp_clear (&vd);
  vorbis_comment_clear (&vorbis_comments);
  vorbis_info_clear (&info);

  fclose (in);
  fclose (out);

  return 0;
}
