/*graf.c
*
*    Copyright (C) 2002, 2003, 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "../pixmaps/stop.xpm"
#include "../pixmaps/play.xpm"
#include "../pixmaps/pause.xpm"
#include "../pixmaps/next.xpm"
#include "../pixmaps/eject.xpm"
#include "../pixmaps/back.xpm"
#include "../pixmaps/logo.xpm"
#include "../pixmaps/comp1.xpm"
#include "../pixmaps/disc.xpm"
#include "../pixmaps/rip.xpm"

#include<libintl.h>

#include<iconv.h> /* iconv(3): To convert to UTF-8 */

#include<errno.h>

#include<stdio.h>
#include<string.h>
#include<stdlib.h>

#include"../config.h"

#include"graf.h"
#include"sound.h"
#include"utils.h"
#include"cddb.h"
#include"conf.h"
#include"callbacks.h"

GtkWidget *
ventana_principal (DatosCD * datos)
{
  GtkWidget *win;

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (win), FALSE, FALSE, FALSE);
  gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_CENTER_ALWAYS);
  gtk_window_set_default_size (GTK_WINDOW (win), 310, 165);
  gtk_window_set_title (GTK_WINDOW (win), PACKAGE " " VERSION ":");
  g_signal_connect (G_OBJECT (win), "destroy",
		    G_CALLBACK (Close_Main_Win), (gpointer) datos);

  return win;
}

GtkWidget *
menu (DatosCD * datos)
{
  // const char **imagen = disc_xpm;

  GtkItemFactoryEntry menu_items[] = {
    {_("/_File"), NULL, NULL, 0, "<Branch>"},
    {_("/_File/_Quit"), "<Ctrl>Q", quit, 0,"<StockItem>", GTK_STOCK_QUIT },
    {_("/_Tools"), NULL, NULL, 0, "<Branch>"},
    {_("/_Tools/_Setup"), "<control>S", Configuracion, 0, "<StockItem>", GTK_STOCK_PREFERENCES},
    {_("/_CD"), NULL, NULL, 0, "<Branch>"},
    {_("/_CD/_Back"), "<control>B", menu_back, 0, NULL},
    {_("/_CD/_Play"), "<control>P", menu_play, 0, NULL},
    {_("/_CD/P_ause"),"<control>A", menu_pause, 0, NULL},
    {_("/_CD/_Next"), "<control>N", menu_next, 0, NULL},
    {_("/_CD/S_top"), "<control>T", menu_stop, 0, NULL},
    {_("/_CD/_Eject"),"<control>E", menu_eject, 0, NULL},
    {"/_CD/sep", NULL, NULL, 0, "<Separator>"},
    {_("/_CD/CDDB"), "<control>C", menu_CDDB, 0, NULL},
    {_("/_CD/Check Disc"), "<control>D", menu_Check, 0, NULL},
    {_("/_Rip"), NULL, NULL, 0, "<Branch>"},
    {_("/_Help/_About"), "<control>A", about, 0, NULL},
    {"/", NULL, start_rip, 0, "<StockItem>", Make_Stock_Image ( (const gchar **)rip_xpm)},
  };

  Graf *graf = datos->graf;
  GtkItemFactory *item;
  GtkAccelGroup *accel;
  int entrys = sizeof (menu_items) / sizeof (menu_items[0]);

  accel = gtk_accel_group_new ();

  item = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<menu>", accel);
  gtk_window_add_accel_group (GTK_WINDOW (graf->win), accel);

  gtk_item_factory_create_items (item, entrys, menu_items, (gpointer) datos);

  return gtk_item_factory_get_widget (item, "<menu>");

}

void
botones (DatosCD * datos)
{
  /* This struct contain the register to make the buttons */
  struct buttons
  {
    char *tip; /* Tip of the button */
    void (*func) (); /* Function to run*/
    char **img; /* The image of the button*/
  }
  bot[] =
  {
    {_("Back Ctrl+B"), back_track, back_xpm},
    {_("Play Ctrl+P"), play_cd, play},
    {_("Pause Ctrl+A"), pause_track, pause_xpm},
    {_("Next Ctrl+N"), next_track, next_xpm},
    {_("Stop Ctrl+T"), stop_cd, stop_xpm},
    {_("Eject Ctrl+E"), eject_cd, eject_xpm},
    {_("Check CDDB Ctrl+C"), Look_Up_CDDB, comp1_xpm},
    {_("Check Disc Ctrl+D"),thread_check_disc, disc_xpm}
  };
  GtkWidget *boton;
  Graf *graf = datos->graf;
  unsigned int i;

  /* On this for we make the buttons */
  for (i = 0; i < sizeof (bot) / sizeof (bot[0]); i++)
    {
      boton = Imagen_Boton (graf, bot[i].img);

      g_signal_connect (G_OBJECT (boton), "clicked",
			G_CALLBACK (bot[i].func), (gpointer) datos);

      gtk_tooltips_set_tip (ToolTip (), boton, bot[i].tip, NULL);
      gtk_box_pack_start (GTK_BOX (graf->hbox3), boton, TRUE, TRUE, 0);
      gtk_widget_show (boton);
    }

}

GtkWidget *
Image (GtkWidget * win, char **nombre)
{
  GdkColormap *colormap;
  GdkBitmap *mask;
  GdkPixmap *pixmap;
  GtkWidget *pixmapw;

  colormap = gtk_widget_get_colormap (win);
  pixmap =
    gdk_pixmap_colormap_create_from_xpm_d (win->window, colormap, &mask, NULL,
					   nombre);
  pixmapw = gtk_image_new_from_pixmap (pixmap, mask);

  return pixmapw;
}

GtkWidget *
Imagen_Boton (Graf * graf, char **nombre)
{
  GtkWidget *boton;
  GtkWidget *image;

  image = Image (graf->win, nombre);
  boton = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (boton), image);
  gtk_widget_show (image);
  gtk_widget_set_size_request (GTK_WIDGET (boton), 30, 30);

  return boton;
}

const gchar *
Make_Stock_Image (const gchar **name)
{
  //  char *stock = (char *) calloc ( (int) strlen (name), sizeof (char *));
  const gchar *stock = (gchar *) calloc ( (gint) strlen ((const char *)name), sizeof (gchar *));
  GdkPixbuf *pixbuf;
  GtkIconSet *icon_set;
  GtkIconFactory *factory;

  //  snprintf (stock, (int) strlen (name), "%s", name);
  g_snprintf ((gchar *)stock, (gint) strlen ((const char *)name), "%s", (gchar *)name);
  factory = gtk_icon_factory_new ();
  gtk_icon_factory_add_default (factory);

  pixbuf = gdk_pixbuf_new_from_xpm_data (name);
  
  icon_set = gtk_icon_set_new_from_pixbuf (pixbuf);

  gtk_icon_factory_add (factory, stock, icon_set);

  return stock;
}

/* This function it's not considered like a callback */
void
about (gpointer data, unsigned int action, GtkWidget * widget)
{
  GtkWidget *Window;
  GtkWidget *logo;
  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *button;

  Window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (Window), _("About Apolos"));
  gtk_container_set_border_width (GTK_CONTAINER (Window), 5);
  gtk_widget_set_size_request (GTK_WIDGET (Window), 400, 300);
  g_signal_connect (G_OBJECT (Window), "destroy",
		    G_CALLBACK (gtk_widget_destroy), Window);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (Window), vbox);

  logo = Image (Window, logo_xpm);

  gtk_box_pack_start (GTK_BOX (vbox), logo, TRUE, TRUE, 0);
  gtk_widget_show (logo);
  label =
    gtk_label_new (_(PACKAGE " " VERSION
		   " is a CDPlayer for GNU/Linux written in C.\n"
		   "Release under the GNU Public License\n"
		   "Copyright 2002 Jonathan Gonzalez V. <zeus@emacs.cl>\n\n"
		   "Developers Team:\n"
		   "                 Jonathan Gonzalez V. <zeus@emacs.cl>\n"
		   "                 Davidlohr Bueso A. <dbueso@linuxchile.cl>\n"));
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);

  button = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_widget_set_size_request (GTK_WIDGET (button), 40, 50);
  gtk_box_pack_end (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  g_signal_connect (G_OBJECT (button), "clicked",
		    G_CALLBACK (Cerrar), (gpointer) Window);

  gtk_widget_show (button);

  gtk_widget_show (vbox);
  gtk_widget_show (Window);
}

int
update (DatosCD * datos)
{
  char *buff = (char *) calloc (10, sizeof(char *));
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;

  if (cd->checkin_disc == TRUE)
    return 0;

  if (cd->existcd == TRUE)
    {
      if (cd->cddb_ok == FALSE)
	{
	  snprintf (buff, 10, _("Track %d"), cd->track);
	  gtk_label_set (GTK_LABEL (graf->label_track), buff);
	}
      
      if (cd->tocando == FALSE)
	{
	  snprintf (buff, 10, "%02d:%02d", cd->trackactual->time->minutos,
		    cd->trackactual->time->sec);
	  gtk_label_set_text (GTK_LABEL (graf->label_time), buff);
	}
    }
  else
    {
      snprintf (buff, 10, "--:--");
      gtk_label_set_text (GTK_LABEL (graf->label_time), buff);

      snprintf (buff, 10, _("No Disc"));
      gtk_label_set_text (GTK_LABEL (graf->label_track), buff);
      
      snprintf (buff, 10, " ");
      
      gtk_label_set_text (GTK_LABEL (graf->label_title), buff);
      gtk_label_set_text (GTK_LABEL (graf->label_artista), buff);	
      
    }

  free (buff);
  
  return 0;
}

void
dibujar_time (DatosCD * datos)
{
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;
  char *buff = (char *) calloc (20, sizeof (char *));


  if (cd->existcd == TRUE)
    {
      snprintf (buff, 20, "%02d:%02d", cd->trackactual->time->minutos,
		cd->trackactual->time->sec);
      graf->label_time = gtk_label_new (buff);

      snprintf (buff, 20, "%s", cd->trackactual->titulo->texto);
      graf->label_track = gtk_label_new (buff);

    }
  else
    {
      graf->label_time = gtk_label_new ("--:--");

      graf->label_track = gtk_label_new (_("No Disc"));
    }

  graf->label_artista = gtk_label_new (NULL);
  gtk_table_attach_defaults (GTK_TABLE (graf->table), graf->label_artista,
			     1, 2, 0, 1);
  gtk_widget_show (graf->label_artista);

  graf->label_title = gtk_label_new (NULL);
  gtk_table_attach_defaults (GTK_TABLE (graf->table), graf->label_title, 
			     1, 2, 1, 2);
  gtk_widget_show (graf->label_title);

  gtk_table_attach_defaults (GTK_TABLE (graf->table), graf->label_time, 
			     0, 1, 0, 1);
  gtk_widget_show (graf->label_time);

  gtk_table_attach_defaults (GTK_TABLE (graf->table), graf->label_track, 
			     0, 1, 1, 2);
  gtk_widget_show (graf->label_track);

  free (buff);
}

GtkWidget *
CheckButton (char * name, int checked)
{
  GtkWidget *boton;

  boton = gtk_check_button_new_with_label (name);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (boton), checked);

  return boton;
}

void
Controles (DatosCD * datos)
{
  
  //  GtkObject *adj = NULL;
  GtkWidget *scale = NULL;
  GtkWidget *label = NULL;
  Datos *cd = datos->cd;
  Graf *graf = datos->graf;
  Vols *vols = datos->vols;

  /* Shuffle check button */

  graf->boton_lista = CheckButton (_("Play List"), FALSE);
  gtk_widget_set_sensitive (graf->boton_lista, cd->existcd);
  g_signal_connect (G_OBJECT (graf->boton_lista), "clicked",
		    G_CALLBACK (Lista_Tracks), (gpointer) datos);
  gtk_box_pack_start (GTK_BOX (graf->vbox2), graf->boton_lista, FALSE,
		      FALSE, 0);
  gtk_widget_show (graf->boton_lista);

  /* Shuffle check button */ 

  graf->boton_barajado = CheckButton (_("Shuffle"), FALSE);
  gtk_widget_set_sensitive (graf->boton_barajado, cd->existcd);
  g_signal_connect (G_OBJECT (graf->boton_barajado), "clicked",
		    G_CALLBACK (Barajado), (gpointer) datos->cd);
  gtk_box_pack_start (GTK_BOX (graf->vbox2), graf->boton_barajado, FALSE,
		      FALSE, 0);
  gtk_widget_show (graf->boton_barajado);

  /* Repeat check button :) */
  
  graf->boton_repeat = CheckButton (_("Repeat"), FALSE);
  gtk_widget_set_sensitive (graf->boton_repeat, cd->existcd);
  g_signal_connect (G_OBJECT (graf->boton_repeat), "clicked",
		    G_CALLBACK (Repeat), (gpointer) datos->cd);
  gtk_box_pack_start (GTK_BOX (graf->vbox2), graf->boton_repeat, FALSE,
		      FALSE, 0);
  gtk_widget_show (graf->boton_repeat);
  
  /* The sound control of CD */

  label = gtk_label_new ("CD");
  gtk_box_pack_start (GTK_BOX (graf->vbox2), label, FALSE, FALSE, 0);
  gtk_widget_show (label);
 
  graf->adj_cd = gtk_adjustment_new (vols->cdrom->left, 0.0, 101.0, 0.1, 0.1, 0.1);

  g_signal_connect (G_OBJECT (graf->adj_cd), "value-changed",
		    G_CALLBACK (Change_Volume), (void *) vols->cdrom);

  scale = gtk_hscale_new (GTK_ADJUSTMENT (graf->adj_cd));
  gtk_scale_set_draw_value (GTK_SCALE (scale), FALSE);
  gtk_scale_set_digits (GTK_SCALE (scale), 0);
  gtk_widget_set_size_request(scale, -1, 12);
  gtk_box_pack_start (GTK_BOX (graf->vbox2), scale, FALSE, FALSE, 0);
  gtk_widget_show (scale);

  /* Volume Sound Control (Volume)*/

  label = gtk_label_new (_("Vol"));
  gtk_box_pack_start (GTK_BOX (graf->vbox2), label, FALSE, FALSE, 0);
  gtk_widget_show (label);
  
  graf->adj_vol = gtk_adjustment_new(vols->vol->left, 0.0, 101.0, 0.1, 0.1, 0.1);
  
  g_signal_connect (G_OBJECT (graf->adj_vol), "value-changed",
		    G_CALLBACK (Change_Volume), (void *) vols->vol);
  scale = gtk_hscale_new(GTK_ADJUSTMENT(graf->adj_vol));
  gtk_scale_set_draw_value(GTK_SCALE(scale), FALSE);
  gtk_scale_set_digits(GTK_SCALE(scale), 0);
  gtk_widget_set_size_request(scale, -1, 12);
  gtk_box_pack_start(GTK_BOX(graf->vbox2), scale, FALSE, FALSE, 0);
  gtk_widget_show(scale);
  
}

/* This function it's not considered like a callback */
void
Lista_Tracks (GtkWidget * widget, gpointer data)
{
  GtkTreeIter iter;
  GtkCellRenderer *render;
  GtkTreeSelection *selection;
  GtkTreePath *path = NULL;
  int i;
  char *titles[5] = { _("Play"), _("Track"), _("Title"), _("Length"), _("Rip")};
  char *row[3];
  char buf[2];
  DatosCD *datos = (DatosCD *) data;
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;
  
  if (cd->lista == FALSE && cd->existcd == TRUE)
    {
      /*
	The play list into the main window looks great!!
	but anyway I think that should be something optional :)
      */
      if (strcmp (cd->playlist_mainwin, "0") == 0)
	{
	  graf->win_list = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	  gtk_window_set_title (GTK_WINDOW (graf->win_list),
				PACKAGE " " VERSION " - Track List");
	  gtk_widget_set_size_request (GTK_WIDGET (graf->win_list), 200,
				       (cd->total_track <=
					19) ? cd->total_track * 22 : 19 * 22);
	  g_signal_connect (G_OBJECT (graf->win_list), "destroy",
			    G_CALLBACK (destruir_winlist), (gpointer) datos);
	  gtk_widget_show (graf->win_list);
	  
	  gtk_container_set_border_width (GTK_CONTAINER (graf->win_list), 4);
	  
	  graf->scrolled = gtk_scrolled_window_new (NULL, NULL);
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (graf->scrolled),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);
	  
	  gtk_container_add (GTK_CONTAINER (graf->win_list), graf->scrolled);
	  
	}
      else 
	{
	  graf->scrolled = gtk_scrolled_window_new (NULL, NULL);
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (graf->scrolled),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC);
	  
	  gtk_widget_set_size_request(GTK_WIDGET (graf->main_vbox), 310, 165 + ((cd->total_track <= 19) ? cd->total_track * 22: 19 * 22));
	  gtk_box_pack_end (GTK_BOX (graf->main_vbox), graf->scrolled, FALSE, FALSE, 0);
	  gtk_widget_set_size_request (GTK_WIDGET (graf->scrolled), 310, (cd->total_track <= 19) ? cd->total_track * 22: 19 * 22);
      }
      
      gtk_widget_show (graf->scrolled);
      
      graf->treestore = gtk_tree_store_new (5, 
					    G_TYPE_BOOLEAN, 
					    G_TYPE_STRING, 
					    G_TYPE_STRING, 
					    G_TYPE_STRING, 
					    G_TYPE_BOOLEAN);

      graf->tree = gtk_tree_view_new_with_model (
						 GTK_TREE_MODEL (graf->treestore));
      gtk_container_add (GTK_CONTAINER (graf->scrolled), graf->tree);

      gtk_widget_show (graf->tree);

      g_signal_connect (G_OBJECT (graf->tree), "row-activated",
			G_CALLBACK (play_track_from_playlist), (gpointer) cd);

      do
	{
	  row[0] = (char *) calloc (5, sizeof (char *));
	  row[1] = (char *) calloc (50, sizeof (char *));
	  row[2] = (char *) calloc (8, sizeof (char *));

	  snprintf (row[0], 5, "%02d", cd->tracklist->track);
	  snprintf (row[1], 50, "%s", cd->tracklist->titulo->texto);
	  snprintf (row[2], 8, "%02d:%02d", cd->tracklist->time->minutos,
		    cd->tracklist->time->sec);

	  gtk_tree_store_append (graf->treestore, &iter, NULL);
	  gtk_tree_store_set (graf->treestore, &iter,
			      0, cd->tracklist->play, 1, row[0], 2, row[1], 
			      3, row[2], 4, cd->tracklist->rip, -1);
	  
	  if (cd->track == cd->tracklist->track)
	    {
	      snprintf (buf, 2, "%d", cd->track - 1);
	      path = gtk_tree_path_new_from_string (buf);
	    }

	  free (row[0]);
	  free (row[1]);
	  free (row[2]);
	  cd->tracklist = cd->tracklist->next;
	}
      while (cd->tracklist != cd->header);

      cd->tracklist = cd->header;
      selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (graf->tree));
      render = gtk_cell_renderer_text_new ();

      if (path)
	gtk_tree_selection_select_path (selection, path);

      render = gtk_cell_renderer_toggle_new ();  
      gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (graf->tree), -1,
						   titles[0], render, 
						   "active", 0, NULL);
      g_signal_connect (render, "toggled",
			G_CALLBACK (play_toggled), (gpointer)datos);
      
      for (i = 1; i < 4; i++)
	{
	  render = gtk_cell_renderer_text_new ();
	  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW(graf->tree), -1,
						       titles[i], render,
						       "text", i, NULL);	    
	}


      render = gtk_cell_renderer_toggle_new ();
      gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (graf->tree), -1,
						   titles[4], render,
						   "active", 4, NULL);
      g_signal_connect (render, "toggled",
			G_CALLBACK (rip_toggled), (gpointer) datos);

      cd->lista = TRUE;
    }
  else if (cd->lista == TRUE)
    {
      if (strcmp (cd->playlist_mainwin, "1") == 0)
	{
	  gtk_widget_destroy (graf->scrolled);
	  gtk_widget_set_size_request (GTK_WIDGET (graf->main_vbox), 310, 165);
	}
      else
	gtk_widget_destroy (graf->win_list);

      cd->lista = FALSE;
    }
}

GtkTooltips *
ToolTip ()
{
  GtkTooltips *tooltip;

  tooltip = gtk_tooltips_new ();

  return tooltip;
}

void 
List_Servers (gpointer data)
{
  int i;
  char buf[2];
  char *titles[5] =
    { _("Server Host"), _("Port"), _("Latitude"), _("Longitude"), _("Description") };

  GtkTreeIter iter;
  GtkWidget *scrolled;
  GtkCellRenderer *render;
  GtkTreeSelection *selection;
  GtkTreePath *path = NULL;
  DatosCD *datos;
  Datos *cd;
  Graf *graf;

  datos = (DatosCD *) data;

  cd = datos->cd;
  graf = datos->graf;

  if (cd->serverlist == TRUE)
    {
      gtk_widget_destroy (graf->win_servers);
      cd->serverlist = FALSE;
    }
  else
    {
      
      graf->win_servers = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (GTK_WINDOW (graf->win_servers),
			    PACKAGE " " VERSION " - Servers List");
      gtk_widget_set_size_request (GTK_WIDGET (graf->win_servers), 330, 245);
      g_signal_connect (G_OBJECT (graf->win_servers), "destroy",
			G_CALLBACK (gtk_widget_destroyed), NULL);

      gtk_container_set_border_width (GTK_CONTAINER (graf->win_servers), 4);

      scrolled = gtk_scrolled_window_new (NULL, NULL);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
      gtk_container_add (GTK_CONTAINER (graf->win_servers), scrolled);
      gtk_widget_show (scrolled);

      graf->listservers =
	gtk_list_store_new (5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
			    G_TYPE_STRING, G_TYPE_STRING);

      graf->treeservers = gtk_tree_view_new ();
      gtk_container_add (GTK_CONTAINER (scrolled), graf->treeservers);
      gtk_tree_view_set_model (GTK_TREE_VIEW (graf->treeservers),
			       GTK_TREE_MODEL (graf->listservers));
      gtk_widget_show (graf->treeservers);

      

      for (i = 0; cd->cddb->Servers != NULL; i++)
	{
	  gtk_list_store_append (graf->listservers, &iter);

	  gtk_list_store_set (graf->listservers, &iter,
			      0, cd->cddb->Servers->host,
			      1, cd->cddb->Servers->port,
			      2, cd->cddb->Servers->latitud,
			      3, cd->cddb->Servers->longitud, 
			      4, cd->cddb->Servers->description, -1);

	  if (strcmp (cd->cddb->Servers->host, cd->cddb->servidor) == 0)
	    {
	      snprintf (buf, 2, "%d", i);
	      path = gtk_tree_path_new_from_string (buf);
	    }
	  cd->cddb->Servers = cd->cddb->Servers->next;
	}

      selection =
	gtk_tree_view_get_selection (GTK_TREE_VIEW (graf->treeservers));

      if (path)
	gtk_tree_selection_select_path (selection, path);

      for (i = 0; i < 5; i++)
	{
	  render = gtk_cell_renderer_text_new ();
	  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW
						       (graf->treeservers),
						       -1, titles[i], render,
						       "text", i, NULL);
	}

      cd->cddb->Servers = cd->cddb->header;
      gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
      g_signal_connect (G_OBJECT (selection), "changed",
			G_CALLBACK (select_server), (gpointer) cd);

      gtk_widget_show (graf->win_servers);

    }
}

void
MSG_to_Statusbar (Graf *graf, char *msg)
{
  gtk_statusbar_push (GTK_STATUSBAR (graf->statusbar), graf->context_id, msg);
}

void
remove_MSG_Statusbar (Graf *graf)
{
  gtk_statusbar_pop (GTK_STATUSBAR (graf->statusbar), graf->context_id);
}

void 
Error (char *msg, char *function)
{
  GtkWidget *window;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *img;
  GtkWidget *label;
  GtkWidget *separate;
  GtkWidget *button;

  char message[100];

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("Error"));
  gtk_widget_set_size_request (GTK_WIDGET (window), 250, 150);
  gtk_container_set_border_width (GTK_CONTAINER (window), 20);

  vbox = gtk_vbox_new (FALSE, 20);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  img = gtk_image_new_from_stock (GTK_STOCK_DIALOG_ERROR, GTK_ICON_SIZE_DIALOG);
  gtk_widget_show (img);

  gtk_box_pack_start (GTK_BOX (hbox), img, FALSE, FALSE, 0);

  snprintf (message, 100, _("Error while '%s':\n%s"), function, msg);

  label = gtk_label_new (message);
  gtk_widget_show (label);

  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);


  separate = gtk_hseparator_new ();
  gtk_widget_show (separate);
  gtk_box_pack_start (GTK_BOX (vbox), separate, TRUE, FALSE, 0);

  button = gtk_button_new_from_stock (GTK_STOCK_OK);
  g_signal_connect (G_OBJECT (button), "clicked",
		    G_CALLBACK (Cerrar), (gpointer) window);
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);

  gtk_widget_show (window);
}

int 
scroll_text (Cadena *text, int characters, GtkWidget *label)
{
  int largo, o;

  if (text->largo <= characters)
    {
      strcpy (text->scroll1, text->texto);
      strcpy (text->scroll2, text->texto);
      gtk_label_set_text (GTK_LABEL (label), text->scroll1);
      
      return 0;
    }
  
  if (text->spaces > 0)
    {
      strcat (text->scroll1++, " ");
      text->spaces--;

      text->scroll1 = free_char_memory (text->scroll1, characters);
    }
  else
    {
      largo = strlen (text->scroll1);
      
      if (largo == 0)
	{
	  strcpy (text->scroll2, text->texto);
	  strncpy (text->scroll1, text->scroll2, characters);
	  text->scroll2 = text->scroll2+characters;
	}
      else if(largo <= characters)
	{
	  text->scroll1++;
	  largo = strlen (text->scroll1);

	  text->scroll1 = free_char_memory (text->scroll1, characters);

	  strncat (text->scroll1, text->scroll2, characters - largo);
	  text->scroll2++;
	}
    }
  if (text->scroll2[0] == '\0')
    {
      for (o = text->largo; o > 0 ; o--)
	text->scroll2--;
      
      text->spaces = 4;
    }

  gtk_label_set_text (GTK_LABEL (label), text->scroll1);
  
  return 0;
}

int 
anime (gpointer data)
{
  DatosCD *datos = data;
  Datos *cd = datos->cd;
  Graf *graf = datos->graf;

  if (cd->existcd == FALSE || cd->cddb_ok == FALSE || cd->checkin_disc == TRUE)
    return TRUE;

  scroll_text (cd->Disco->titulo, TRACK_TITLE_SCROLL, graf->label_title);

  scroll_text (cd->Disco->artista, TRACK_ARTIST_SCROLL, graf->label_artista);

  scroll_text (cd->trackactual->titulo, 15, graf->label_track);
      
  return TRUE;
}

int
change_main_title (Graf *graf, Datos *cd)
{
  char *titulo = (char *) calloc (100, sizeof (char *));

  if (cd->cddb_ok == FALSE)
    return -1;

  snprintf (titulo, 100, PACKAGE " " VERSION ": %s - %s", 
	    cd->Disco->artista->texto, cd->trackactual->titulo->texto);
  gtk_window_set_title (GTK_WINDOW (graf->win), titulo);

  free (titulo);
  
  return 0;
}

int
draw_barra (Graf *graf, Datos *cd)
{
  int secs;
  DatosCD *datos = (DatosCD *) malloc (sizeof (DatosCD));
  
  datos->graf = graf;
  datos->cd = cd;

  secs = cd->trackactual->time->sec + 
    (cd->trackactual->time->minutos * 60);

  if (graf->adj != NULL)
    gtk_object_destroy (graf->adj);

  graf->adj = gtk_adjustment_new (0.0, 0.0, secs+1, 1.0, 30.0, 1.0);
  
  g_signal_connect (G_OBJECT (graf->adj), "value-changed",
		    G_CALLBACK (play_from), (gpointer) datos);
  
  if (graf->scale != NULL)
    gtk_widget_destroy (graf->scale);

  graf->scale = gtk_hscale_new (GTK_ADJUSTMENT (graf->adj));
  gtk_scale_set_draw_value (GTK_SCALE (graf->scale), FALSE);
  gtk_box_pack_start (GTK_BOX (graf->hbox), graf->scale, TRUE, TRUE, 0);
  gtk_widget_show (graf->scale);

  cd->barra = TRUE;
  
  return 0;
}

void 
kill_adjustment (Graf *graf) 
{ 
  gtk_object_destroy (graf->adj);
  graf->adj = NULL;
  gtk_widget_destroy (graf->scale);
  graf->scale = NULL;
} 

int
set_time (Graf *graf, Datos *cd, int minute, int second)
{
  char *buffer = (char *) calloc (6, sizeof (char *));
  double value;

  cd->trans_sec = second;
  cd->trans_minutos = minute;

  snprintf (buffer, 6, "%02d:%02d", cd->trans_minutos, cd->trans_sec);

  gtk_label_set_text (GTK_LABEL (graf->label_time), buffer);
  free (buffer);

  value = gtk_adjustment_get_value (GTK_ADJUSTMENT (graf->adj));
  
  if (value < (minute * 60) + second)
    gtk_adjustment_set_value (GTK_ADJUSTMENT (graf->adj), (minute * 60) + second);

  return 0;
}

int 
update_playlist (DatosCD *datos)
{

  Graf *graf = datos->graf;
  Datos *cd = datos->cd;

  gint i;

  gchar *titles[5] = { _("Play"), _("Track"), _("Title"), _("Length"), _("Rip")};
  gchar *row[3];
  gchar buf[2];
  
  GtkTreeIter iter;
  GtkCellRenderer *render;
  GtkTreeSelection *selection;
  GtkTreePath *path = NULL;


  gtk_container_remove (GTK_CONTAINER (graf->scrolled), graf->tree);
  //  gtk_widget_destroy (graf->treestore);
  gtk_widget_destroy (graf->tree);
  

  graf->treestore =
    gtk_tree_store_new (5, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
  
  graf->tree =
    gtk_tree_view_new_with_model (GTK_TREE_MODEL (graf->treestore));
  gtk_container_add (GTK_CONTAINER (graf->scrolled), graf->tree);
  
  gtk_widget_show (graf->tree);

  do
    {
      row[0] = (char *) calloc (5, sizeof (char *));
      row[1] = (char *) calloc (50, sizeof (char *));
      row[2] = (char *) calloc (8, sizeof (char *));
      
      snprintf (row[0], 5, "%02d", cd->tracklist->track);
      snprintf (row[1], 50, "%s", cd->tracklist->titulo->texto);
      snprintf (row[2], 8, "%02d:%02d", cd->tracklist->time->minutos,
		cd->tracklist->time->sec);
      
      gtk_tree_store_append (graf->treestore, &iter, NULL);
      gtk_tree_store_set (graf->treestore, &iter,
			  0, cd->tracklist->play, 1, row[0], 2, row[1], 
			  3, row[2], 4, cd->tracklist->rip, -1);
      
      if (cd->track == cd->tracklist->track)
	{
	  snprintf (buf, 2, "%d", cd->track - 1);
	  path = gtk_tree_path_new_from_string (buf);
	}
      
      free (row[0]);
      free (row[1]);
      free (row[2]);
      cd->tracklist = cd->tracklist->next;
    }
  while (cd->tracklist != cd->header);
  
  cd->tracklist = cd->header;
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (graf->tree));
  render = gtk_cell_renderer_text_new ();
  
  if (path)
    gtk_tree_selection_select_path (selection, path);
  
  render = gtk_cell_renderer_toggle_new ();  
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (graf->tree), -1,
					       titles[0], render, 
					       "active", 0, NULL);
  g_signal_connect (render, "toggled",
		    G_CALLBACK (play_toggled), (gpointer)datos);
  
  for (i = 1; i < 4; i++)
    {
      render = gtk_cell_renderer_text_new ();
      gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW(graf->tree), -1,
						   titles[i], render,
						   "text", i, NULL);	    
    }
  
  //      gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
  
  render = gtk_cell_renderer_toggle_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (graf->tree), -1,
					       titles[4], render,
					       "active", 4, NULL);
  g_signal_connect (render, "toggled",
		    G_CALLBACK (rip_toggled), (gpointer) datos);
  
  return 0;
}

GtkWidget *
progress_win (DatosCD *datos)
{
  GtkWidget *win;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *frame;

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  //  gtk_window_set_policy (GTK_WINDOW (win), FALSE, FALSE, FALSE, 3);
  gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_CENTER_ALWAYS);
  gtk_window_set_title (GTK_WINDOW (win), PACKAGE " " VERSION ": Rip and Encode");
  g_signal_connect (G_OBJECT (win), "destroy",
		    G_CALLBACK (gtk_widget_destroy), NULL);

  
  vbox = gtk_vbox_new (FALSE, 3);
  gtk_container_add (GTK_CONTAINER (win), vbox);
  gtk_widget_show (vbox);

  frame = gtk_frame_new ("Rip progress: ");
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 3);
  gtk_widget_show (frame);



}
