/*graf.h
*
*    Copyright (C) 2002, 2003, 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include"types.h"

#ifndef _GRAF_H

#define _GRAF_H

/* This bug was reported by: Ren J. Blokland */
/* and the solution was sent by: Alvaro herrera */
#define _(String) gettext(String)

GtkWidget *ventana_principal (DatosCD * datos);

GtkWidget *menu (DatosCD * datos);

void botones (DatosCD * datos);

GtkWidget *crear_barra ();

GtkWidget *tracks ();

/* This function it's not considered like a callback */
void about (gpointer data, unsigned int action, GtkWidget * widget);

GtkWidget *Imagen_Boton (Graf * graf, gchar ** nombre);

/* This function run every 1 second */
int update (DatosCD * datos);

void dibujar_time (DatosCD * datos);

GtkWidget *CheckButton (char *name, int checked);

/* This function it's not considered like a callback */
void Lista_Tracks (GtkWidget * widget, gpointer data);

void Controles (DatosCD * datos);

GtkWidget *Image (GtkWidget * win, gchar ** nombre);

void Error (char *msg, char *function);

GtkTooltips *ToolTip ();

void List_Servers (gpointer data);

/* This function writes a message on statusbar */
void MSG_to_Statusbar (Graf *graf, char *msg);

/* This other function remove the last message on statusbar */
void remove_MSG_Statusbar (Graf *graf);

//void Change_Volume (GtkAdjustment *adj, void * data);

/* anime (): This function, move the labels */
int anime (gpointer data);

/* This function, move the text inside text->texto */
int scroll_text (Cadena *text, int characters, GtkWidget *label);

/* Change the title of main window */
int change_main_title (Graf *graf, Datos *cd);

int draw_barra (Graf *graf, Datos *cd);

/* This funciton kill the adjustment and scale of the timeline */
void kill_adjustment (Graf *graf);

const gchar * Make_Stock_Image (const gchar **name);

int set_time (Graf *graf, Datos *cd, int minute, int second);

int update_playlist (DatosCD *datos);

GtkWidget * progress_win (DatosCD *datos);
#endif
