/*types.h
*
*    Copyright (C) 2002, 2003, 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<gtk/gtk.h>

#include<pthread.h>

#include "../config.h"
#ifdef ENABLE_NLS

#include<libintl.h>
#define _(String) gettext(String)

#endif

#include"vol.h"

#ifndef FALSE

#define FALSE 0

#endif

#ifndef TRUE

#define TRUE 1

#endif

#ifndef _TYPES_H

#define _TYPES_H

#define TRACK_TITLE_SCROLL 15
#define TRACK_ARTIST_SCROLL 15

typedef struct _cadena_
{
  char *texto;
  char *scroll1;
  char *scroll2;
  int largo;
  int spaces;
}
Cadena;


typedef struct _info_track
{
  int minutos;
  int sec;
  int frame;
}
Track;

typedef struct _tracklist
{
  struct _tracklist *back;
  int track;
  gboolean play;
  gboolean rip;
  Track *time;
  Track *offset;
  Track *start;
  Cadena *titulo;
  char *estilo;
  Cadena *artista;
  struct _tracklist *next;
}
Tracklist;

typedef struct Sites_
{
  struct Sites_ *back;
  char *host;
  char *port;
  char *latitud;
  char *longitud;
  char *description;
  struct Sites_ *next;
}
Server;

typedef struct _cddb
{
  GtkWidget *entry;
  Server *Sites;
  int socket;
  int match;
  unsigned int discid;
  char *otherid;
  char buf[2048];
  char NameServer[30];
  char servidor[20];
  char *codigo;
  char puerto[5];
  char autocheck[2];
  Server *Servers;
  Server *header;
}
CDDB;

/* Here the tracks to rip and more info :) */
typedef struct ___rip {
  char *temp_files;
  char *ripped_files;
  int rip_mode;
  /* The Rip and Encode thread */
  pthread_t rip_thread;
  pthread_t encode_thread;
  /* TRUE if we're ripping or encoding*/
  int ripping;
  int encoding;
}
Rip;

typedef struct _graf_cd
{
  GtkWidget *win;
  GtkWidget *win_list;
  GtkWidget *win_config;
  GtkWidget *win_servers;
  GtkWidget *win_progress;
  GtkTreeStore *treestore;
  GtkListStore *listservers;
  GtkWidget *tree;
  GtkWidget *treeservers;
  GtkWidget *menu;
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *vbox2;
  GtkWidget *hbox;
  GtkWidget *hbox2;
  GtkWidget *hbox3;
  GtkWidget *table;
  GtkWidget *label_time;
  GtkWidget *label_track;
  GtkWidget *label_title;
  GtkWidget *label_artista;
  GtkWidget *track_opciones;
  GtkWidget *boton_lista;
  GtkWidget *boton_barajado;
  GtkWidget *boton_repeat;
  GtkWidget *statusbar;
  GtkWidget *scale; /* This types are to make*/
  GtkObject *adj;   /* the "barra"*/
  GtkObject *adj_vol; 
  GtkObject *adj_cd;
  GtkWidget *scrolled;
  unsigned int context_id;
}
Graf;

typedef struct _datos
{
  CDDB *cddb;
  char *cd_device;
  char config_file[256];
  char playlist_mainwin[2];
  unsigned int discid;
  int track;
  int siguiente_track;
  int total_track;
  int fd;
  Tracklist *tracklist;
  Tracklist *header;
  Tracklist *trackactual;
  Tracklist *Disco;
  int trans_minutos;
  int trans_sec;
  int tocando;
  int temp;
  int orden;
  int cdopen;
  int pausa;
  int existcd;
  int lista;
  int barajado;
  int repeat;
  int config;
  int serverlist;
  int cddb_ok;
  int barra;
  /* pthread */
  pthread_t cddb_thread;
  pthread_t check_disc_thread;
  /* TRUE if is checking for a disc */
  int checkin_disc;
} 
Datos;

typedef struct _info_graf_cd
{
  Graf *graf;
  Datos *cd;
  Vols *vols;
  Rip *rip;
} 
DatosCD;

#endif
