/*utils.c
*
*    Copyright (C) 2003, 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdlib.h>
#include<string.h>
#include<sys/stat.h>

#include"types.h"
#include"sound.h"
#include"cddb.h"
#include"utils.h"

void
complet (Datos * cd)
{
  cd->tracklist = NULL;

  cd->cddb->socket = -1;
  cd->track = 1;
  cd->tocando = FALSE;

  if (cd->lista != TRUE)
    cd->lista = FALSE;
  
  cd->barajado = FALSE;

  cd->total_track = ListaTracks (cd);

  
  llenar_lista (cd);

  cd->tracklist = cd->header;
  cd->cddb_ok = FALSE;

  if (cd->existcd == TRUE)
      Cal_Time (cd);

  cd->trackactual = Find_Track (cd, cd->track);
 
  cd->discid = DiscID (cd);
  
}

void
llenar (Tracklist *list)
{
  /* If we want to play this track: default TRUE*/
  list->play = TRUE;
  /* If we want to rip this track: default TRUE*/
  list->rip = TRUE;
  
  list->time = (Track *) malloc (sizeof (Track));
  list->offset = (Track *) malloc (sizeof (Track));
  list->start = (Track *) malloc (sizeof (Track));

  list->titulo = (Cadena *) malloc (sizeof (Cadena));
  list->titulo->texto = (char *) calloc (100, sizeof (char *));
  list->titulo->scroll1 = (char *) calloc (TRACK_TITLE_SCROLL, sizeof (char *));
  list->titulo->scroll2 = (char *) calloc (TRACK_TITLE_SCROLL, sizeof (char *));
  list->titulo->spaces = 0;
  list->estilo = (char *) calloc (15, sizeof (char *));
  list->artista = (Cadena *) malloc (sizeof (Cadena));
  list->artista->texto = (char *) calloc (100, sizeof (char *));
  list->artista->scroll1 = (char *) calloc (TRACK_ARTIST_SCROLL, sizeof (char *));
  list->artista->scroll2 = (char *) calloc (TRACK_ARTIST_SCROLL, sizeof (char *));
  list->artista->spaces = 0;

}

/* This function assigns the memory to use in the program */
void
llenar_lista (Datos * cd)
{
  int i;
  Tracklist *nueva = NULL;

  for (i = 0; i <= cd->total_track; i++)
    {
      if (cd->tracklist != NULL)
	{
	  while (cd->tracklist->next != cd->header)
	    cd->tracklist = cd->tracklist->next;
	  /*
	    cd->tracklist->next = (Tracklist *) malloc (sizeof (Tracklist));
	    nueva = cd->tracklist->next;
	  */
	  nueva = (Tracklist *) malloc (sizeof (Tracklist));
	  nueva->back = cd->tracklist;
	  nueva->track = i + 1;
	  nueva->next = cd->header; 
	  llenar (nueva);
	  cd->tracklist->next = nueva;
	}
      else
	{
	  cd->tracklist = (Tracklist *) malloc (sizeof (Tracklist));
	  cd->tracklist->back = cd->tracklist;
	  cd->tracklist->track = i + 1;
 	  cd->tracklist->next = cd->tracklist; 
 	  cd->header = cd->tracklist; 
	  llenar (cd->tracklist);
	}
    }

  nueva = NULL;

  cd->Disco = (Tracklist *) malloc (sizeof (Tracklist));
  cd->Disco->back = NULL;
  cd->Disco->track = cd->total_track + 1;
  llenar (cd->Disco);
  cd->Disco->next = NULL;
    
}

/* Find_Track return NULL if the track could not be found
or Tracklist * if the track was found*/
Tracklist *
Find_Track (Datos * cd, int track)
{
  Tracklist *encontrado;

  cd->tracklist = cd->header;

  while (1)
    {
      if (cd->tracklist->track == track)
	{
	  encontrado = cd->tracklist;
	  cd->tracklist = cd->header;
	  return encontrado;
	}
      else
	cd->tracklist = cd->tracklist->next;
    }
  return NULL; 
}

void
get_value (char *line, char *value, char sep)
{
  int i = 0;

  while (*line != '\n')
    {
      if (*line == sep)
	i = 1;
      if (i == 1 && *line != sep && *line != '\r')
	*value++ = *line;
      line++;
    }
}
void
get_name (char *line, char *name)
{
  while (*line != '=')
    {
      *name++ = *line;
      line++;
    }
}

int
check_file (char *filename)
{
  struct stat filestat;

  if (stat (filename, &filestat) != 0)
    return FALSE;
  else
    return TRUE;
}

int 
check_dictory (char *dictory)
{
  struct stat dictstat;

  if ( stat (dictory, &dictstat) != 0)
    return FALSE;
  else
    {
      if (S_ISDIR (dictstat.st_mode) != 0)
      	return TRUE;
      else
	return FALSE;
    }
}

/*
This function it's only to free the memory in string, and reassign new memory.
*/
char *
free_char_memory (char *string, int larg)
{
  char *alt_string = (char *) calloc (larg, sizeof (char *));

  strcpy (alt_string, string); /* We copy the string in alt_string */

  free (--string); /* We free string */

  string = (char *) calloc (larg, sizeof (char *)); /* Re-assign memory to string */
  
  strcpy (string, alt_string); /* We put the alt_string in string */
  
  free (alt_string); /* free alt_string */
  
  return string;
}

int free_memory_Tracklist (Tracklist *list)
{
  free (list->time);
  free (list->offset);
  free (list->start);

  free (list->titulo->texto);
  free (list->titulo->scroll1);
  free (list->titulo->scroll2);
  free (list->titulo);

  free (list->estilo);

  free (list->artista->texto);
  free (list->artista->scroll1);
  free (list->artista->scroll2);
  free (list->artista);

  return 0;
}
/*
This function free all the memory allocated with llenar_lista()
 */
int 
free_lista (Datos *cd)
{
  Tracklist *list = NULL;
  Tracklist *alt = NULL;
  Tracklist *header = NULL;

  if (cd->existcd == TRUE)
    {
      header = cd->header;
      list = cd->header;
      
      /*
	dirty way I think, and doesn't work ;)
      */
      do {
	alt = list->next;
	free_memory_Tracklist (list);
	free (list);
	list = alt;
      } while (list != header);

      /*      for (i = 0; i <= cd->total_track; i++)
	{
	  
	}*/

      free (list->next);
      free_memory_Tracklist (cd->Disco);
      free (cd->Disco);
    }

  return 0;
}
/*
This function free the all memory take it in DatosCD *datos
 */
int 
free_all_memory (DatosCD *datos)
{
  Graf *graf = datos->graf;
  Datos *cd = datos->cd;

  /* Free the memory of the track list*/
  free_lista (cd);

  free (cd->cd_device);

  /* Free the memory take it to CDDB */
  free (cd->cddb->Servers);
  free (cd->cddb);

  /* Free the memory take it to Volume control */
  free (datos->vols->vol);
  free (datos->vols->cdrom);
  free (datos->vols);

  /* Free the main types */
  free (graf);
  free (cd);
  free (datos);
  

  return 0;
}
