/*vol.h
*
*    Copyright (C) 2003, 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _VOL_H

#define _VOL_H

#define LEFT_MASK 0x00FF
#define RIGHT_MASK 0xFF00

/* This type  save the macro and volume of the device */
typedef struct _dev_vol 
{
  int macro;
  double left;
  double right;
}
Volume;

/* Here we save the devices to use */
typedef struct _vol
{
  Volume *cdrom;
  Volume *vol;
}
Vols;

/* This function assign the memory to Vols type */
void Assign_Memory (Vols *vols);

/* Get the volume from /dev/mixer */
void Get_Volume (Vols *vols);

/* Set the volume */
void Set_Volume (Volume *vol);

#endif
