/*  Emacs mode: -*- C++ -*-  */

/*  "class File" for Phillips spectrum  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef FILE_PHILLIPS_H
#define FILE_PHILLIPS_H


/****************  includes  ****************/


#include "file.h"


/****************  inherited classes  ****************/


class File_Phillips : public File
{
 public:

  /*  variables  */
  float spectrum_factor;
  float smallest_wave;
  float wind_speed;
  float wind_angle;


  File_Phillips(char *input_file, char *output_file) throw(const char *);


  /****  read  ****/

  /*  reads "Input_file" and initializes variables  */
  virtual void read_configure(void) throw(const char *);
  /*  reads "Input_file" and initializes variables  */
  virtual void read_header(void) throw(const char *);


  /****  write  ****/

  /*  writes template file (i.e. variables strings) into "Output_file"  */
  virtual void write_configure_template(void) const throw(const char *);
  /*  writes header into "Output_file"  */
  virtual void write_header(void) const throw(const char *);


 protected:

  /*  variables strings  */
  const char * const String_spectrum_factor;
  const char * const String_smallest_wave;
  const char * const String_wind_speed;
  const char * const String_wind_angle;


  /*  copy constructor to be defined  */
  File_Phillips(const class File_Phillips &);
};


#endif  /*  FILE_PHILLIPS_H  */
