/*  Begin main.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "file_phillips.h"
#include "options_local.h"
#include "surface_phill_ugauss.h"

/*  local lib  */
#include "lib/exceptions.h"

/*  C++ lib  */
#include <exception>  /*  class exception  */
#include <new>        /*  bad_alloc  */

/*  C lib  */
extern "C"
{
#include <stdlib.h>  /*  EXIT_SUCCESS  */
}


/****************  namespaces  ****************/


using namespace std;


/****************  functions  ****************/


int
main(int argc, char** argv)
{
  try
    {
      class Options_Arguments_Local arguments;
      class Options_Local options(argc, argv);

      options.parse(&arguments);

       if (arguments.is_template)
	{
	  class File_Phillips file(arguments.input_file, arguments.output_file);

	  file.write_configure_template();
	}
      else
	{
	  class Surface_Phill_Ugauss surface(arguments.input_file,
					     arguments.output_file,
					     arguments.get_is_verbose());

	  surface.compute_and_write();
	}
    }
  catch(const char *exception)
    {
      exceptions(argv[0], exception);
    }
  catch(class bad_alloc &exception)
    {
      exceptions(argv[0], exception);
    }
  catch(class exception &exception)
    {
      exceptions(argv[0], exception);
    }

  return EXIT_SUCCESS;
}


/*  End main.cpp  */
