/*  Begin options_local.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "options_local.h"

/*  local include  */
#include "include/version.h"

/*  local lib  */ 
#include "lib/options_libaqua.h"

/*  C++ lib  */
#include <iostream>
#include <sstream>


/****************  namespaces  ****************/


using namespace std;


/*******************************************************************/
/****************  Program_Options_Arguments_Local  ****************/
/*******************************************************************/


/****************  public functions  ****************/


Options_Arguments_Local::Options_Arguments_Local(void)
{
  this->input_file = NULL;
  this->output_file = NULL;
  this->is_output_file = false;
  this->is_silent = false;
  this->is_template = false;
}


/****  set  ****/

void
Options_Arguments_Local::set_is_output_file(bool is_output_file)
{
  this->is_output_file = is_output_file;
}


void
Options_Arguments_Local::set_is_silent(bool is_silent)
{
  this->is_silent = is_silent;
}


/****  get  ****/

bool
Options_Arguments_Local::get_is_verbose(void) const
{
  /*  be verbose if not silent and not writing to stdout  */
  return !this->is_silent && this->is_output_file;
}


/*********************************************************/
/****************  Program_Options_Local  ****************/
/*********************************************************/


/****************  public functions  ****************/


Options_Local::Options_Local(int argc, char **argv)
  : Options_Libaqua(argc, argv, "o:sthv", 1, Version_aqua_gen)
{
  this->set_usage(this->Program_name);
  this->set_options();
}


/****************  protected functions  ****************/


/****  set  ****/

void
Options_Local::set_usage(const char *program_name)
{
  ostringstream temp_stream;

  temp_stream << "Usage: " << program_name << " [-o file [-s]] file\n"
	      << "       " << program_name << " [-o file] -t\n"
	      << "       " << program_name << " -h | -v\n"
	      << "\n"
	      << "Options:\n"
	      << "  -o, --output file   output into \"file\"\n"
	      << "    -s, --silent      don't output anything to stdout\n"
	      << "  -t, --template      write template file\n"
	      << "  -h, --help          display this help\n"
	      << "  -v, --version       display version\n"
    ;

  this->usage = temp_stream.str();
}


void
Options_Local::set_options(void)
{
  this->options = new struct option[5];

  this->option_init(&options[0], "help", no_argument, NULL, 'h');
  this->option_init(&options[1], "version", no_argument, NULL, 'v');
  this->option_init(&options[2], "output", required_argument, NULL, 'o');
  this->option_init(&options[3], "silent", no_argument, NULL, 's');
  this->option_init(&options[4], "template", no_argument, NULL, 't');
}


/****  parse  ****/

void
Options_Local::parse_options_args(class Options_Arguments *arguments,
				  int output_getopt) const
{
  class Options_Arguments_Local *temp_arguments;


  temp_arguments = dynamic_cast<class Options_Arguments_Local *>(arguments);

  switch(output_getopt)
    {
    case 'o':
      temp_arguments->output_file = optarg;
      temp_arguments->set_is_output_file(true);
      break;
      
    case 's':
      temp_arguments->set_is_silent(true);
      break;
      
    case 't':
      temp_arguments->is_template = true;
      break;
      
    case 'h':
      this->display_usage(false);
      break;

    case 'v':
      this->display_version();
      break;

    default:
      this->display_usage(true);
    }
}


void
Options_Local::parse_non_options_args(class Options_Arguments *arguments,
				      char **argv,
				      int optind,
				      int remaining_arguments) const
{
  /*  get input file  */

  class Options_Arguments_Local *temp_arguments;


  temp_arguments = dynamic_cast<class Options_Arguments_Local *>(arguments);

  if (!temp_arguments->is_template)
    {
      if (remaining_arguments == 1)
	{
	  temp_arguments->input_file = argv[optind];
	}
      else
	{
	  cerr << this->Program_name << ": missing input file\n"
	       << endl
	    ;
	  this->display_usage(true);
	}
    }
  else
    {
      if (remaining_arguments == 1)
	{
	  cerr << this->Program_name << ": too many arguments\n"
	       << endl
	    ;
	  this->display_usage(true);
	}
    }
}


/*  End options_local.cpp  */
