/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef SURFACE_H
#define SURFACE_H


/****************  abstract classes  ****************/


class Surface
{
 public:

  Surface(bool is_verbose) throw(const char *);

  virtual ~Surface(void) = 0;


  void compute_and_write(void) const throw(const char *);


 protected:

  const bool Is_verbose;

  class File *file;
  class Aqua_Surface *surface;
  float frame_length;  /*  seconds  */
  int frames_number;


  /*  should be called in inherited classes constructor  */
  void init(class File *file);

  /*  get  */
  float get_frame_length(int frames_per_second) const;
  int get_frames_number(int loop_time, int frames_per_second) const;


  /*  copy constructor to be defined  */
  Surface(const class Surface &);
};


#endif  /*  SURFACE_H  */
