/*  Begin surface_phill_ugauss.cpp  */

/*  "class Surface" with "class Aqua_Surface_Phill_Ugauss"  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "surface_phill_ugauss.h"

#include "file_phillips.h"

/*  libaqua  */
#include "src/aqua_surface_phill_ugauss.h"


/****************  namespaces  ****************/


using namespace std;


/****************  public functions  ****************/


Surface_Phill_Ugauss::Surface_Phill_Ugauss(char *input_file,
					   char *output_file,
					   bool is_verbose) throw(const char *)
  : Surface(is_verbose)
{
  class File_Phillips *file;

  this->file = new class File_Phillips(input_file, output_file);

  this->file->read_configure();

  file = dynamic_cast<class File_Phillips *>(this->file);
  this->surface = new class Aqua_Surface_Phill_Ugauss(file->points_x,
						      file->points_z,
						      file->size_x,
						      file->size_z,
						      file->depth,
						      file->displacement_factor,
						      file->spectrum_factor,
						      file->smallest_wave,
						      file->wind_speed,
						      file->wind_angle,
						      file->loop_time);
  this->init(this->file);
}


Surface_Phill_Ugauss::~Surface_Phill_Ugauss(void)
{
  delete this->surface;
  delete this->file;
}


/*  End surface_phill_ugauss->cpp  */
