/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef CAMERA_H
#define CAMERA_H


/****************  enumerations  ****************/


/*
  Observing: turn the camera means rotate the scene around the origin.
  Flying: roaming the land.
  Swimming: as Flying but "move" functions do nothing.
*/
enum camera_view_mode { Observing = 0, Flying = 1, Swimming = 2 };


/****************  classes  ****************/


class Camera
{
 public:

  enum camera_view_mode view_mode;


  /*  creates a camera at the origin, looking down the Z axis  */
  Camera(enum camera_view_mode view_mode);
  virtual ~Camera(void);


  /****  set  ****/

  /*  Observing -> Flying -> Swimming  */
  void view_mode_switch(void);
  /*  sets camera position (in meters), looking down the Z axis  */
  void reset(float position_x, float position_y, float position_z);
  void set_position_y(float position_y);


  /****  move  ****/

  void move_forward(void);
  void move_backward(void);
  void move_left(void);
  void move_right(void);
  void move_up(void);
  void move_down(void);

  /*  angles in degrees  */
  void turn(float angle_x, float angle_y);


  /****  get  ****/

  /*
    fills three elements "position" vector with "opposite" camera position
    (i.e. suitable for OpenGL transforms)
  */
  void get_opposite_position(float *position) const;
  /*  gets angles in degrees  */
  void get_angle(float &angle_x, float &angle_y) const;


 protected:

  float position_x;   /*  meters   */
  float position_y;   /*  meters   */
  float position_z;   /*  meters   */
  float angle_x;      /*  degrees  */
  float angle_y;      /*  degrees  */
  float angle_y_rad;  /*  radians  */
};


#endif  /*  CAMERA_H  */
