/*  Emacs mode:  -*- C++ -*-  */

/*  help message for Phillips spectrum  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef HELP_PHILLIPS_H
#define HELP_PHILLIPS_H


/****************  includes  ****************/


#include "help.h"

/*  C++ lib  */
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  inherited classes  ****************/


class Help_Phillips : public Help
{
 public:

  const char Key_spectrum_factor_decrease;
  const char Key_spectrum_factor_increase;
  const char Key_smallest_wave_decrease;
  const char Key_smallest_wave_increase;
  const char Key_wind_speed_decrease;
  const char Key_wind_speed_increase;
  const char Key_wind_angle_decrease;
  const char Key_wind_angle_increase;


  Help_Phillips(void);


 protected:

  string create_message(const char *separator);


  /*  copy constructor to be defined  */
  Help_Phillips(const class Help_Pillips &);

};


/****************  external functions  ****************/


/*  fills "help" with general help and phillips spectrum help  */
extern void help_phillips_get(string *help);


#endif  /*  HELP_PHILLIPS_H  */
