/*  Begin options_local.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "options_local.h"

/*  local include  */
#include "include/version.h"

/*  local lib  */ 
#include "lib/options_libaqua.h"

/*  C++ lib  */
#include <sstream>


/*******************************************************************/
/****************  Program_Options_Arguments_Local  ****************/
/*******************************************************************/


/****************  public functions  ****************/


Options_Arguments_Local::Options_Arguments_Local(void)
{
  this->is_fullscreen = false;
}


/*********************************************************/
/****************  Program_Options_Local  ****************/
/*********************************************************/


/****************  public functions  ****************/


Options_Local::Options_Local(int argc, char **argv)
  : Options_Libaqua(argc, argv, "fhv", 0, Version_aqua_demo)
{
  this->set_usage(this->Program_name);
  this->set_options();
}


/****************  protected functions  ****************/


/****  set  ****/

void
Options_Local::set_usage(const char *program_name)
{
  ostringstream temp_stream;

  temp_stream << "Usage: " << program_name << " [-f][-h][-v]\n"
	      << "\n"
	      << "Options:\n"
	      << "  -f, --fullscreen   run in fullscreen mode\n"
	      << "  -h, --help         display this help\n"
	      << "  -v, --version      display version\n"
    ;

  this->usage = temp_stream.str();
}


void
Options_Local::set_options(void)
{
  this->options = new struct option[3];

  this->option_init(&options[0], "help", no_argument, NULL, 'h');
  this->option_init(&options[1], "version", no_argument, NULL, 'v');
  this->option_init(&options[2], "fullscreen", no_argument, NULL, 'f');
}


/****  parse  ****/

void
Options_Local::parse_options_args(class Options_Arguments *arguments,
				  int output_getopt) const
{
  class Options_Arguments_Local *temp_arguments;


  temp_arguments = dynamic_cast<class Options_Arguments_Local *>(arguments);

  switch(output_getopt)
    {
    case 'f':
      temp_arguments->is_fullscreen = true;
      break;
      
    case 'h':
      this->display_usage(false);
      break;

    case 'v':
      this->display_version();
      break;

    default:
      this->display_usage(true);
    }
}


void
Options_Local::parse_non_options_args(class Options_Arguments *arguments,
				      char **argv,
				      int optind,
				      int remaining_arguments) const
{
  /*  avoids compiler warnings for unused parameters  */
  static_cast<void>(arguments);
  static_cast<void>(argv);
  static_cast<void>(optind);
  static_cast<void>(remaining_arguments);
}


/*  End options_local.cpp  */
