/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef SUN_H
#define SUN_H


/****************  includes  ****************/


/*  graphic lib  */
extern "C"
{
#include <GL/gl.h>
}


/****************  classes  ****************/


class Sun
{
 public:

  Sun(GLenum light,        /*  light to which the sun is connected  */
      float distance,      /*  distance from the origin, in meters  */
      float day_length,    /*  seconds  */
      float latitude,      /*  latitude of the observer, in degrees  */
      float day_of_year);  /*  [0, 2pi[, in radians, 0 is march equinox  */ 
  virtual ~Sun(void);


  /****  set  ****/

  /*  "time" in seconds  */
  void set_position(float time);


  /****  get  ****/

  /*  fills three elements vector "position"  */
  void get_position(float *position) const;
  float get_radius(void) const;


 protected:

  GLenum light;                /*  GL light  */
  float distance;              /*  distance from the origin, in meters  */
  float radius;                /*  radius of the sun, in meters  */
  float angular_speed;         /*  rad.s-1  */
  float position_base_x_mult;  /*  bases for "position" computation  */
  float position_base_y_mult;
  float position_base_y_add;
  float position_base_z_mult;
  float position_base_z_add;
  float position[4];           /*  four elements vector  */

  void radius_set(float distance);
  void position_base_set(float latitude, float day_of_year);
};


#endif  /*  SUN_H  */
