/*  Emacs mode: -*- C++ -*-  */

/*  OpenGL viewing and projection transformations  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef TRANSFORM_H
#define TRANSFORM_H


/****************  external functions  ****************/


/*  viewing transformation for the scene  */
extern void transform_scene_push(class Scene *scene, class Camera *camera);
extern void transform_scene_pop(void);

/*  viewing transformation for the sun  */
extern void transform_sun_push(class Sun *sun, class Camera *camera);
extern void transform_sun_pop(void);

/*  projection transformation for string  */
extern void transform_string_push(bool draw_from_top);
extern void transform_string_pop(void);


#endif  /*  TRANSFORM_H  */
