/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef OPTIONS_H
#define OPTIONS_H


/****************  includes  ****************/


/*  C++ lib  */
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  abstract classes  ****************/


class Options_Arguments
{
 public:

  virtual ~Options_Arguments(void) = 0;
};


class Options
{
 public:

  const char * const Program_name;

  Options(int argc, char **argv);
  virtual ~Options(void) = 0;

  virtual void parse(class Options_Arguments *arguments) const = 0;


 protected:

  const int Argc;
  char * * const argv;
  string usage;
  string version;


  /*  set  */
  virtual void set_usage(const char *program_name) = 0;
  virtual void set_version(const char *program_name) = 0;

  /*  display  */
  void display_usage(bool is_error) const;
  void display_version(void) const;


  /*  copy constructor to be defined  */
  Options(const class Options &);
};


#endif  /*  OPTIONS_H  */
