/*  Begin options_getopt.cpp  */

/*  "class Options" using "getopt()"  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "options_getopt.h"

/*  local lib  */ 
#include "options.h"
extern "C"
{
#include "getopt.h"
}

/*  C++ lib  */
#include <iostream>


/****************  public functions  ****************/


Options_Getopt::Options_Getopt(int argc,
			       char **argv,
			       char *shortopts,
			       int non_option_arguments)
  : Options(argc, argv),
    Shortopts(shortopts),
    Non_option_arguments(non_option_arguments)
{
}


/*  virtual destructor  */
Options_Getopt::~Options_Getopt(void)
{
}


void
Options_Getopt::parse(class Options_Arguments *arguments) const
{
  int output_getopt;
  int remaining_arguments;


  /*  parses options arguments  */
  while(true)
    {
      output_getopt = getopt_long(this->Argc,
				  this->argv,
				  this->Shortopts,
				  this->options,
				  NULL);

      /*  no more option  */
      if (output_getopt == -1)
	{
	  break;
	}

      this->parse_options_args(arguments, output_getopt);
    }

  /*  parses remaining arguments  */
  remaining_arguments = this->Argc - optind;
  if (remaining_arguments > this->Non_option_arguments)
    {
      cerr << this->Program_name << ": too many arguments\n"
	   << endl
	;
      this->display_usage(true);
    }
  else
    {
      this->parse_non_options_args(arguments,
				   this->argv,
				   optind,
				   remaining_arguments);
    }
}


/****************  protected functions  ****************/


void
Options_Getopt::option_init(struct option *option,
			    const char *name,
			    int has_arg,
			    int *flag,
			    int val)
{
  option->name = name;
  option->has_arg = has_arg;
  option->flag = flag;
  option->val = val;
}


/*  End options_getopt.cpp  */
