/*  Emacs mode: -*- C++ -*-  */

/*  "class Options" using "getopt()"  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef OPTIONS_GETOPT_H
#define OPTIONS_GETOPT_H


/****************  includes  ****************/


#include "options.h"

extern "C"
{
#include "getopt.h"
}


/****************  abstract classes  ****************/


class Options_Getopt : public Options
{
 public:

  Options_Getopt(int argc,
		 char **argv,
		 char *shortopts,
		 int non_option_arguments);
  virtual ~Options_Getopt(void) = 0;

  virtual void parse(class Options_Arguments *arguments) const;

 protected:

  /*  getopt  variables  */
  const char *Shortopts;
  struct option * options;
  const int Non_option_arguments;


  virtual void set_options(void) = 0;
  void option_init(struct option *option,
		   const char *name,
		   int has_arg,
		   int *flag,
		   int val);

  virtual void parse_options_args(class Options_Arguments *arguments,
				  int output_getopt) const = 0;
  virtual void parse_non_options_args(class Options_Arguments *arguments,
				      char **argv,
				      int optind,
				      int remaining_arguments) const = 0;
};


#endif  /*  OPTIONS_GETOPT_H  */
