/*  Begin options_libaqua.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "options_libaqua.h"

#include "options_getopt.h"

/*  local includes  */
#include "include/version.h"

/*  C++ lib  */
#include <sstream>


/****************  public functions  ****************/


Options_Libaqua::Options_Libaqua(int argc,
				 char **argv,
				 char *shortopts,
				 int non_option_arguments,
				 const char *version_program)
  : Options_Getopt(argc, argv, shortopts, non_option_arguments),
    Version_program(version_program)
{
  this->set_version(this->Program_name);
}


/*  virtual destructor  */
Options_Libaqua::~Options_Libaqua(void)
{
}


/****************  protected functions  ****************/


void
Options_Libaqua::set_version(const char *program_name)
{
  ostringstream temp_stream;

  temp_stream << program_name << " " << this->Version_program
	        << " (libaqua " << Version_libaqua << ")\n"
	      << "\n"
	      << Version_gpl << "\n"
    ;

  this->version = temp_stream.str();
}


/*  End options_libaqua.cpp  */
