/*  Emacs mode: -*- C++ -*-  */

/*  fast Fourier transforms  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_FFT_H
#define _AQUA_FFT_H


/****************  includes  ****************/


#include "config.h"

/*  FFTW lib  */
extern "C"
{
#include <fftw3.h>
}


/****************  enumerations  ****************/


/*  Type of FFT input, purely real or purely imaginary.  */
enum aqua_fft_input_type { Real = 0, Imaginary = 1 };


/****************  classes  ****************/


class Aqua_Fft
{
 public:

  const int size_x;            /*  logical size of the array  */
  const int size_z;


  /*
    sets a two dimensional backward real or imaginary to real FFT
    of size "size_x" * "size_z" with plan of FFTW type "plan_type"
    and input in [ -size_x / 2, size_x / 2 [ * [ -size_z / 2, size_z / 2 [
  */
  Aqua_Fft(int size_x,
	   int size_z,
	   unsigned int plan_type = Config_aqua_fft_plan_type);
  virtual ~Aqua_Fft(void);


  /*
    Computes a two dimensional backward FFT with "reals_array" as input AND
    output.
    The input is purely real or purely imaginary, depending on "input_type".
    The output is purely real.
  */
  void compute(float **reals_array, enum aqua_fft_input_type input_type) const;


 protected:

  const int size_x_by_two;     /*  size / 2  */
  const int size_z_by_two;
  const int array_width;/*(i,j) element of array is array[i * array_width + j]*/

  fftwf_plan plan;       /*  FFTW plan used for the FFT   */
  fftwf_complex *array;  /*  FFTW array used for the FFT  */


  void copy_reals_array_to_array(float **reals_array,
				 int size_x,
				 int size_z,
				 fftwf_complex *array,
				 int array_width) const;
  void copy_array_to_reals_array(float **reals_array,
				 enum aqua_fft_input_type input_type,
				 int size_x,
				 int size_z,
				 int size_x_by_two,
				 int size_z_by_two,
				 fftwf_complex *array,
				 int array_width) const;

  /*  copy constructor to be defined  */
  Aqua_Fft(const class Aqua_Fft &);
};


#endif  /*  _AQUA_FFT_H  */
