/*  Emacs mode: -*- C++ -*-  */

/*  random number generator  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_RNG_H
#define _AQUA_RNG_H


/****************  includes  ****************/


#include "config.h"

/*  GSL lib  */
extern "C"
{
#include <gsl/gsl_rng.h>
}


/****************  abstract classes  ****************/


class Aqua_Rng
{
 public:
 
  Aqua_Rng(const gsl_rng_type *rng_type = Config_aqua_rng_type);
  virtual ~Aqua_Rng(void) = 0;


  /*  get  */

  /*  returns a random number  */
  virtual float get_number(void) const = 0;


 protected:

  gsl_rng *generator;  /*  random number generator  */

  /*  copy constructor to be defined  */
  Aqua_Rng(const class Aqua_Rng &);
};


#endif  /*  _AQUA_RNG_H  */
