/*  Begin aqua_rng_ugaussian.cpp  */

/*  random number generator with unit gaussian distribution  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "aqua_rng_ugaussian.h"

#include "aqua_rng.h"

/*  GSL lib  */
extern "C"
{
#include <gsl/gsl_randist.h>
}


/****************  public functions  ****************/


Aqua_Rng_Ugaussian::Aqua_Rng_Ugaussian(void)
  : Aqua_Rng()
{
}


Aqua_Rng_Ugaussian::Aqua_Rng_Ugaussian(const gsl_rng_type *rng_type)
  : Aqua_Rng(rng_type)
{
}


/****  get  ****/

/*  returns a random number of uniform gaussian distribution  */
float
Aqua_Rng_Ugaussian::get_number(void) const
{
  return gsl_ran_ugaussian(this->generator);
}


/*  End aqua_rng.cpp  */
