/*  Emacs mode: -*- C++ -*-  */

/*  "Aqua_Surface_Phillips" with unit gaussian distribution  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_SURFACE_PHILL_UGAUSS_H
#define _AQUA_SURFACE_PHILL_UGAUSS_H


/****************  includes  ****************/


#include "aqua_surface_phillips.h"


/****************  classes  ****************/


class Aqua_Surface_Phill_Ugauss : public Aqua_Surface_Phillips
{
 public:

  /*  creates a surface and set it at time 0.0  */
  Aqua_Surface_Phill_Ugauss(int points_x,  /* numbers of discrete sample...   */
			    int points_z,  /* ...points, must be power of two */
			    float size_x,               /*  meters  */
			    float size_z,               /*  meters  */
			    float depth, /* of water, meters, 0 means infinite*/
			    float displacement_factor,  /*  horizontal  */
			    float spectrum_factor,
			    float smallest_wave,        /*  meters  */
			    float wind_speed,
			    float wind_angle,
			    float loop_time = 0.0); /*seconds, 0 means no loop*/


 protected:

  /*  temporary object, used to initialize the base class  */
  class Aqua_Rng_Ugaussian *rng;

  /*  copy constructor to be defined  */
  Aqua_Surface_Phill_Ugauss(const class Aqua_Surface_Phill_Ugauss &);
};


#endif  /*  _AQUA_SURFACE_PHILL_UGAUSS  */
